/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.config.ReadOnlyDbCheckConfig;
import com.bokesoft.distro.tech.bootsupport.starter.i18n.StringTable;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.intf.IDBWatcher;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBReadOnlyStatus;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBWatchData;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import com.bokesoft.yigo.common.trace.TraceSystemManager;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
@EnableScheduling
public class ReadOnlyWatchConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(ReadOnlyWatchConfigurer.class);
    private static final List<IDBWatcher> dbWatcherList = new ArrayList<IDBWatcher>();
    @Autowired
    private YigoInstanceManager yigoInstanceManager;
    @Autowired
    private ReadOnlyDbCheckConfig config;

    @PostConstruct
    public void initDBWatcher() {
        ServiceLoader<IDBWatcher> loader = ServiceLoader.load(IDBWatcher.class);
        ArrayList<IDBWatcher> cache = new ArrayList<IDBWatcher>();
        Iterator<IDBWatcher> it = loader.iterator();
        while (it.hasNext()) {
            cache.add(it.next());
        }
        dbWatcherList.addAll(DependencySortCore.sort(cache));
    }

    @Scheduled(cron="${yigoee.tech.bootsupport.readonly-follower.db-watch.schedule: 0 */5 * * * ?}")
    public void task() {
        ServerSetting serverSetting = ServerSetting.getInstance();
        if (null != serverSetting && serverSetting.isReadOnly() && this.yigoInstanceManager.isInitializationComplete()) {
            TraceSystemManager.withTraceLog(() -> {
                this.doReadOnlyCheck();
                return null;
            }, (Object)this, (boolean)true, (Logger)logger, (Level)Level.INFO);
        }
    }

    private void doReadOnlyCheck() {
        try {
            SessionUtils.processWithContext(null, context -> {
                IDBManager idbManager = context.getDBManager();
                IDBWatcher watcher = this.getSuitableDBWather(idbManager);
                if (null == watcher) {
                    return null;
                }
                DBWatchData watchData = watcher.doCheck(context, this.config);
                if (null == watchData) {
                    logger.error("\u53ea\u8bfb\u670d\u52a1\u5065\u5eb7\u68c0\u67e5: \u8fd4\u56de\u6570\u636e\u4e0d\u6b63\u786e( watchData = null )");
                    this.yigoInstanceManager.markUnavaliableReason(ReadOnlyWatchConfigurer.class, this.watchDataIsNullI18N());
                } else if (DBReadOnlyStatus.OK.equals((Object)watchData.getStatus())) {
                    logger.info("\u53ea\u8bfb\u670d\u52a1\u5065\u5eb7\u68c0\u67e5: \u72b6\u6001\u6b63\u5e38");
                    this.yigoInstanceManager.cleanUnavaliableEvent(ReadOnlyWatchConfigurer.class);
                } else {
                    logger.error("\u53ea\u8bfb\u670d\u52a1\u5065\u5eb7\u68c0\u67e5: \u72b6\u6001\u5f02\u5e38, {}", (Object)watchData.getDescription());
                    this.yigoInstanceManager.markUnavaliableReason(ReadOnlyWatchConfigurer.class, watchData.getReason());
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.yigoInstanceManager.markUnavaliableReason(ReadOnlyWatchConfigurer.class, this.dbQueryErrI18N());
        }
    }

    private IDBWatcher getSuitableDBWather(IDBManager dbManager) {
        int dbType = dbManager.getDBType();
        for (IDBWatcher watcher : dbWatcherList) {
            if (!watcher.support(dbType)) continue;
            return watcher;
        }
        logger.warn("\u53ea\u8bfb\u670d\u52a1\u5065\u5eb7\u68c0\u67e5: \u627e\u4e0d\u5230 dbType {} \u5bf9\u5e94\u7684 IDBWatcher", (Object)dbType);
        return null;
    }

    private String dbQueryErrI18N() {
        return StringTable.i18N(null, "DBReadOnlyCheckFaild", TraceRecorder.getTraceId());
    }

    private String watchDataIsNullI18N() {
        return StringTable.i18N(null, "WatchDataIsNull", TraceRecorder.getTraceId());
    }
}

