package com.bokesoft.distro.tech.bootsupport.starter.info;

import com.bokesoft.distro.tech.bootsupport.starter.api.AppRuntimeInfoProvider;

import java.util.concurrent.atomic.AtomicBoolean;

public class AppRuntimeInfoProviderFactory {

    private static AppRuntimeInfoProvider provider;

    private static final AtomicBoolean registered = new AtomicBoolean(false);

    public static void register(AppRuntimeInfoProvider provider){
        if (!registered.compareAndSet(false, true)) {
            throw new RuntimeException("不能重复注册:" + AppRuntimeInfoProvider.class.getName());
        }
        AppRuntimeInfoProviderFactory.provider = provider;
    }


    public static AppRuntimeInfoProvider getAppRuntimeInfoProvider(){
        return provider == null ? new BlankAppRuntimeInfoProvider() : provider;
    }

    static class BlankAppRuntimeInfoProvider implements AppRuntimeInfoProvider{
        @Override
        public Info getInfo() {
            Info info = new Info();
            info.setExternalInfo("待扩展");
            return info;
        }

        @Override
        public Boolean getEnvDirtyFlag() {
            return null;
        }
    }

}
