package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.base.bokebase.instance.ProcessInstanceUtil;
import com.bokesoft.distro.tech.bootsupport.starter.instance.impl.YigoBootProcessInstanceProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

import javax.annotation.PostConstruct;
import javax.management.MalformedObjectNameException;

@Configuration
public class ProcessInstanceProviderConfigure  {

    private final Environment environment;

    public ProcessInstanceProviderConfigure(Environment environment){
        this.environment = environment;
    }

    @PostConstruct
    public void init() throws MalformedObjectNameException {
        Integer port = environment.getProperty("server.port", Integer.class);

        if(null != port){
            ProcessInstanceUtil.setProcessInstanceProvider(new YigoBootProcessInstanceProvider(port));
        }else{
            // 默认使用com.bokesoft.base.bokebase.instance.impl.DefaultProcessInstanceProvider(默认的实例进程ID)
        }
    }

}

