package com.bokesoft.distro.tech.bootsupport.starter.config;

import java.util.List;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import com.bokesoft.distro.tech.bootsupport.starter.deployment.SpringResourceMultiSolutionMetaResolverFactory;
import com.bokesoft.yigo.meta.base.IMetaResolver;

/**
 * 定义 Yigo 模块(包含 Yigo Solution 和 二开)的属性
 */
@Component
@ConfigurationProperties (prefix = YigoModuleConfig.PROP_PREFIX)
public class YigoModuleConfig {
    public static final String PROP_PREFIX = "yigoee.tech.bootsupport.modules";

    /**
     * 需要忽略的 Yigo Solution 资源路径.
     * 路径的具体格式由 {@link IMetaResolver} 的实现确定
     * (注意不是所有实现都支持这个配置项, 已知仅有 {@link SpringResourceMultiSolutionMetaResolverFactory} 支持此配置).
     */
    private List<String> ignoreSolutionResources;

    public List<String> getIgnoreSolutionResources() {
        return ignoreSolutionResources;
    }
    public void setIgnoreSolutionResources(List<String> ignoreSolutionResources) {
        this.ignoreSolutionResources = ignoreSolutionResources;
    }
}
