package com.bokesoft.distro.tech.bootsupport.starter.auth.aspect;

import com.bokesoft.distro.tech.commons.basis.auth.annotation.Logical;
import com.bokesoft.distro.tech.commons.basis.auth.annotation.PermissionCheck;
import com.bokesoft.distro.tech.commons.basis.auth.annotation.RequiresPermission;
import com.bokesoft.distro.tech.bootsupport.starter.auth.strage.PermissionCheckerRegistry;
import com.bokesoft.distro.tech.commons.basis.auth.exception.NoPermissionException;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

import java.util.Arrays;

/**
 * 切面类，用于要求先执行权限权限校验逻辑。
 *
 * <p>该切面会拦截所有标注了 {@link RequiresPermission} 的类中的方法，
 * 并在方法执行前, 执行权限校验逻辑。</p>
 *
 */
@Aspect
@Component
public class PermissionAspect {

    private final PermissionCheckerRegistry permissionCheckerRegistry;

    public PermissionAspect(PermissionCheckerRegistry permissionCheckerRegistry) {
        this.permissionCheckerRegistry = permissionCheckerRegistry;
    }

    /**
     * 根据 {@link RequiresPermission} 注解属性,来判断被标记的方法是否具有执行权限
     * @param requiresPermission
     */
    @Before("@annotation(requiresPermission)")
    public void checkPermission(RequiresPermission requiresPermission) {
        Logical logical = requiresPermission.logical();
        if (logical == Logical.NONE) {
            return;
        }

        PermissionCheck[] PermissionChecks = requiresPermission.value();

        boolean hasPermission = false;

        if (logical == Logical.ALL) {
            hasPermission = Arrays.stream(PermissionChecks).allMatch(permissionCheck -> permissionCheckerRegistry.get(permissionCheck.strategy()).hasPermission(permissionCheck.permission()));
        }

        if (logical == Logical.ANY) {
            hasPermission = Arrays.stream(PermissionChecks).anyMatch(permissionCheck -> permissionCheckerRegistry.get(permissionCheck.strategy()).hasPermission(permissionCheck.permission()));
        }

        if (!hasPermission) {
            throw new NoPermissionException();
        }

    }

}
