/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.scheduler;

import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzManager {
    private static final Logger logger = LoggerFactory.getLogger(QuartzManager.class);
    private static StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
    private static QuartzManager instance = null;

    public static QuartzManager getInstance() {
        if (instance == null) {
            instance = new QuartzManager();
        }
        return instance;
    }

    QuartzManager() {
    }

    public void init(String string) throws Throwable {
        schedulerFactory.initialize(string);
    }

    public void init(InputStream inputStream) throws Throwable {
        if (inputStream != null) {
            schedulerFactory.initialize(inputStream);
        }
    }

    public void addJob(String string, String string2, String string3, String string4, Job job, String object, long l2, int n2, long l3) throws Throwable {
        Scheduler scheduler = schedulerFactory.getScheduler();
        job = JobBuilder.newJob(job.getClass()).withIdentity(string, string2).withDescription((String)object).build();
        object = new Date(l2 + System.currentTimeMillis());
        object = n2 == -1 ? (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(string3, string4).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(l3).repeatForever()).startAt((Date)object).build() : (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(string3, string4).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(l3).withRepeatCount(n2)).startAt((Date)object).build();
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        logger.info("add job.name:{},group:{},trigger.name:{},trigger.group:{},trigger.repeatInterval:{},trigger.repeatCount:{}", new Object[]{string, string2, string3, string4, l3, n2});
        scheduler.scheduleJob((JobDetail)job, hashSet, true);
    }

    public void addJob(String string, String string2, String string3, String string4, Class<? extends Job> jobDetail, String string5, String string6) throws SchedulerException {
        Scheduler scheduler = schedulerFactory.getScheduler();
        jobDetail = JobBuilder.newJob(jobDetail).withIdentity(string, string2).withDescription(string5).build();
        string5 = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(string3, string4).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)string6)).build();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string5);
        scheduler.scheduleJob(jobDetail, hashSet, true);
        logger.info("add job.name:{},group:{},trigger.name:{},trigger.group:{},trigger.cronexp:{}", new Object[]{string, string2, string3, string4, string6});
    }

    public boolean deleteJob(String string, String string2) throws Throwable {
        Scheduler scheduler = schedulerFactory.getScheduler();
        logger.info("delete job.name:{},job.group:{}", (Object)string, (Object)string2);
        return scheduler.deleteJob(new JobKey(string, string2));
    }

    public static boolean checkJobExist(String string, String string2) throws SchedulerException {
        return schedulerFactory.getScheduler().checkExists(new JobKey(string, string2));
    }

    public boolean isStarted() throws SchedulerException {
        return schedulerFactory.getScheduler().isStarted();
    }

    public void start() throws SchedulerException {
        Scheduler scheduler = schedulerFactory.getScheduler();
        logger.info("job start now.");
        scheduler.start();
    }

    public boolean isShutdown() throws SchedulerException {
        return schedulerFactory.getScheduler().isShutdown();
    }

    public void shutdown() throws SchedulerException {
        Scheduler scheduler = schedulerFactory.getScheduler();
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
            logger.info("shutdown job now");
        }
    }

    public boolean isStandby() throws SchedulerException {
        return schedulerFactory.getScheduler().isInStandbyMode();
    }

    public void standby() throws SchedulerException {
        Scheduler scheduler = schedulerFactory.getScheduler();
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.standby();
            logger.info("standby job now");
        }
    }

    public List<JobExecutionContext> getCurrentlyExecutingJobs() throws SchedulerException {
        return schedulerFactory.getScheduler().getCurrentlyExecutingJobs();
    }

    public void clear() throws Throwable {
        Scheduler scheduler = schedulerFactory.getScheduler();
        if (scheduler != null) {
            scheduler.clear();
            logger.info("clear job now");
        }
    }
}

