/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.io.doc;

import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.i18n.StringTable;
import com.bokesoft.yes.mid.io.doc.TableRightsInfo;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.util.MetaColumnRightsUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.rights.DictRights;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableRightsFilter {
    private MetaDataObject dataObject;
    private DataTable table;
    private boolean needCheck = false;
    private HashMap<String, List<Long>> columnReadRightsMap = new HashMap();
    private HashMap<String, HashMap<String, List<Long>>> dynamicColumnReadRightsMap = new HashMap();

    public boolean isNeedCheck() {
        return this.needCheck;
    }

    public TableRightsFilter(MetaDataObject metaDataObject, DataTable dataTable) {
        this.dataObject = metaDataObject;
        this.table = dataTable;
    }

    public void filter(DefaultContext defaultContext, MetaTable metaTable, boolean bl, boolean bl2) throws Throwable {
        this.load(defaultContext, metaTable);
        if (!this.needCheck) {
            return;
        }
        this.table.first();
        DataTable dataTable = this.table.deepClone();
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        while (this.table.isValid()) {
            if (!this.rowCheck(defaultContext, metaTable, hashMap)) {
                this.table.delete();
                if (this.dataObject.getLoadRightsType() == 1 && this.dataObject.getPrimaryType() == 0) {
                    if (SvrInfo.getNoRightInfoType().equalsIgnoreCase(SvrInfo.NoRightInfoType_Complex)) {
                        TableRightsInfo tableRightsInfo = new TableRightsInfo(defaultContext);
                        dataTable.first();
                        tableRightsInfo.checkRights(defaultContext.getEnv().getUserID(), this.dataObject, defaultContext.getFormKey(), metaTable, dataTable);
                    }
                    throw new MidCoreException(18, this.getErrorInfo(defaultContext, metaTable, hashMap));
                }
                if (this.dataObject.getPrimaryType() != 0 || metaTable.getTableMode() != 0 || this.dataObject.getMainTable() != metaTable && bl) continue;
                if (SvrInfo.getNoRightInfoType().equalsIgnoreCase(SvrInfo.NoRightInfoType_Complex)) {
                    TableRightsInfo tableRightsInfo = new TableRightsInfo(defaultContext);
                    dataTable.first();
                    tableRightsInfo.checkRights(defaultContext.getEnv().getUserID(), this.dataObject, defaultContext.getFormKey(), metaTable, dataTable);
                }
                throw new MidCoreException(18, this.getErrorInfo(defaultContext, metaTable, hashMap));
            }
            this.table.next();
        }
        if (bl2) {
            this.table.batchUpdate();
        }
    }

    public String getErrorInfo(DefaultContext defaultContext, MetaTable object, Map<String, Long> object2) throws Throwable {
        Object object3 = defaultContext.getVE().getMetaFactory();
        String string = defaultContext.getFormKey();
        String string2 = object3.getMetaForm(string).getCaption();
        String string3 = "";
        Object object4 = object2.keySet().stream().findFirst();
        if (object4.isPresent()) {
            string3 = (String)object4.get();
        }
        object4 = (MetaColumn)object.get(string3);
        String string4 = object4.getCaption();
        object = (String)MetaColumnRightsUtil.getItemKey((MetaColumn)object4, (String)string, (String)object.getKey(), (DataTable)this.table).get(0);
        object3 = object3.getDataObject((String)object).getCaption();
        object2 = object2.get(string3);
        object4 = "";
        if ((Long)object2 > 0L) {
            object4 = (String)defaultContext.getVE().getDictCache().getItem((String)object, ((Long)object2).longValue()).getValue("Code");
        }
        return String.format(StringTable.getString(null, (String)"", (String)"NoDataObjectAccessPermission"), string, string2, string3, string4, object, object3, object4);
    }

    public boolean rowCheck(DefaultContext defaultContext, MetaTable metaTable, Map<String, Long> map) throws Throwable {
        Object object = MetaFactory.getGlobalInstance().getRightsDefinition();
        if (object == null) {
            return true;
        }
        if ((object = object.getDictRightsCollection()) == null || object.isEmpty()) {
            return true;
        }
        for (MetaColumn metaColumn : metaTable) {
            List<Long> list;
            Object object2;
            if (!MetaColumnRightsUtil.isNeedRight((MetaColumn)metaColumn, (String)defaultContext.getFormKey(), (String)metaTable.getKey(), (DataTable)this.table) || (object2 = metaColumn.getBindingDBColumnName()) == null || ((String)object2).isEmpty()) continue;
            if (!MetaColumnRightsUtil.isDynamicComponent((String)defaultContext.getFormKey(), (String)metaTable.getKey(), (String)metaColumn.getKey())) {
                object2 = TypeConvertor.toLong((Object)this.table.getObject(metaColumn.getKey()));
                list = this.columnReadRightsMap.get(metaColumn.getKey());
                if (list == null || list.contains(object2)) continue;
                map.put(metaColumn.getKey(), (Long)object2);
                return false;
            }
            object2 = TypeConvertor.toLong((Object)this.table.getObject(metaColumn.getKey()));
            list = MetaColumnRightsUtil.getDynamicComponentRefKey((String)defaultContext.getFormKey(), (String)metaTable.getKey(), (String)metaColumn.getKey());
            list = MetaColumnRightsUtil.getColumnKeyOfDynamicComponent((String)defaultContext.getFormKey(), (String)((Object)list));
            list = TypeConvertor.toString((Object)this.table.getObject((String)((Object)list)));
            list = this.dynamicColumnReadRightsMap.get(metaColumn.getKey()).get(list);
            if (list == null || list.contains(object2)) continue;
            map.put(metaColumn.getKey(), (Long)object2);
            return false;
        }
        return true;
    }

    public void load(DefaultContext defaultContext, MetaTable metaTable) throws Throwable {
        Long l2 = defaultContext.getVE().getEnv().getUserID();
        if (this.checkIsAdmin(defaultContext.getDBManager(), l2).booleanValue()) {
            return;
        }
        l2 = MetaFactory.getGlobalInstance().getRightsDefinition();
        if (l2 == null) {
            return;
        }
        if ((l2 = l2.getDictRightsCollection()) == null || l2.isEmpty()) {
            return;
        }
        l2 = null;
        for (MetaColumn metaColumn : metaTable) {
            DictRights dictRights;
            Object object;
            if (!MetaColumnRightsUtil.isNeedRight((MetaColumn)metaColumn, (String)defaultContext.getFormKey(), (String)metaTable.getKey(), (DataTable)this.table) || (object = metaColumn.getBindingDBColumnName()) == null || ((String)object).isEmpty()) continue;
            if (l2 == null) {
                l2 = RightsProviderFactory.getInstance().newRightsProvider(defaultContext);
            }
            object = MetaColumnRightsUtil.getItemKey((MetaColumn)metaColumn, (String)defaultContext.getFormKey(), (String)metaTable.getKey(), (DataTable)this.table);
            if (!MetaColumnRightsUtil.isDynamicComponent((String)defaultContext.getFormKey(), (String)metaTable.getKey(), (String)metaColumn.getKey())) {
                dictRights = l2.getDictRights((String)object.get(0));
                object = new ArrayList();
                if (dictRights.hasAllRights()) continue;
                object.addAll(dictRights.getReadRightIds());
                if (dictRights.hasEmptRights()) {
                    object.add(0L);
                }
                this.needCheck = true;
                this.columnReadRightsMap.put(metaColumn.getKey(), (List<Long>)object);
                continue;
            }
            dictRights = new HashMap();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                DictRights dictRights2 = l2.getDictRights(string);
                ArrayList<Long> arrayList = new ArrayList<Long>();
                if (!dictRights2.hasAllRights()) {
                    arrayList.addAll(dictRights2.getReadRightIds());
                    if (dictRights2.hasEmptRights()) {
                        arrayList.add(0L);
                    }
                    this.needCheck = true;
                    dictRights.put(string, arrayList);
                }
                this.dynamicColumnReadRightsMap.put(metaColumn.getKey(), (HashMap<String, List<Long>>)dictRights);
            }
        }
    }

    public Boolean checkIsAdmin(IDBManager iDBManager, Long l2) throws Throwable {
        String string = "select b.oid, b.isAdmin from SYS_OperatorRole a left join sys_role b on b.oid=a.Role where a.soid = ?";
        if ((iDBManager = iDBManager.execPrepareQuery(string, new Object[]{l2})) != null && !iDBManager.isEmpty()) {
            for (int i2 = 0; i2 < iDBManager.size(); ++i2) {
                if (iDBManager.getInt(i2, "IsAdmin") != 1) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

