/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.io.doc;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.io.doc.DocLockCheck;
import com.bokesoft.yes.mid.relation.RelationProxy;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaSecurityProvider;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.path.MetaSecurityFilter;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.extend.ISecurityProvider;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.ve.VE;
import java.sql.PreparedStatement;

public class DocDelete {
    private Document doc = null;
    private MetaDataObject metaDataObject = null;

    public DocDelete(Document document, MetaDataObject metaDataObject) {
        this.doc = document;
        this.metaDataObject = metaDataObject;
    }

    public Boolean delete(DefaultContext defaultContext) throws Throwable {
        TraceRecorder.traceData((String)"docDelete", (Object)this.doc);
        IDBManager iDBManager = defaultContext.getDBManager();
        MidVE midVE = defaultContext.getVE();
        MetaSecurityFilter metaSecurityFilter = midVE.getMetaFactory().getSecurityFilter(null);
        if (metaSecurityFilter != null) {
            metaSecurityFilter = metaSecurityFilter.getRelationproxy();
            String string = metaSecurityFilter.getImpl();
            ((RelationProxy)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)string)).checkDoc((VE)midVE, iDBManager, this.doc, 3, metaSecurityFilter.isCache().booleanValue());
        }
        this.preSecurityCheck((VE)midVE);
        this.check(defaultContext);
        this.deleteDiret((VE)midVE, iDBManager);
        return Boolean.TRUE;
    }

    private void check(DefaultContext defaultContext) throws Throwable {
        IDBManager iDBManager = defaultContext.getDBManager();
        DocLockCheck.checkAndLock((ILocale)defaultContext.getEnv(), this.doc, this.metaDataObject, iDBManager);
        AuthorityCheckUtil.checkBeforeDelete((DefaultContext)defaultContext);
    }

    public void deleteDiret(VE vE, IDBManager iDBManager) throws Throwable {
        if (this.metaDataObject.getPrimaryType() == 1) {
            return;
        }
        vE = this.metaDataObject.getMainTable();
        if (vE != null) {
            DocDelete docDelete = this;
            docDelete.deleteTableData(docDelete.doc, (MetaTable)vE, iDBManager);
        }
        for (MetaTable metaTable : this.metaDataObject.getTableCollection()) {
            if (metaTable == vE || metaTable.isHidden().booleanValue()) continue;
            DocDelete docDelete = this;
            docDelete.deleteTableData(docDelete.doc, metaTable, iDBManager);
        }
    }

    private void preSecurityCheck(VE vE) throws Throwable {
        Object object = this.metaDataObject.getSecurityProviderCollection();
        if (object != null && (object = (MetaSecurityProvider)object.get("Delete")) != null && (object = object.getProvider()) != null && !((String)object).isEmpty() && (object = (ISecurityProvider)ReflectHelper.newInstance((VE)vE, (String)object)) != null) {
            object.doCheck(vE, this.metaDataObject.getKey(), this.doc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteTableData(Document object, MetaTable metaTable, IDBManager iDBManager) throws Throwable {
        if (!metaTable.isPersist().booleanValue()) {
            return;
        }
        DataTable dataTable = object.get(metaTable.getKey());
        if (dataTable == null) return;
        dataTable.beforeFirst();
        while (dataTable.next()) {
            dataTable.setState(3);
        }
        dataTable.beforeFirst();
        if (iDBManager.saveDataTable(dataTable, metaTable.getKey(), metaTable, object)) {
            return;
        }
        object = null;
        int n2 = 0;
        String string = null;
        try {
            dataTable.beforeFirst();
            while (dataTable.next()) {
                if (object == null) {
                    string = DBUtil.getDeleteSQL((IDBManager)iDBManager, (String)metaTable.getBindingDBTableName(), (String)metaTable.getOIDColumn().getBindingDBColumnName());
                    object = iDBManager.preparedUpdateStatement(string);
                }
                iDBManager.setParameter((PreparedStatement)object, 1, (Object)TypeConvertor.toLong((Object)dataTable.getObject("OID")), 1010);
                if (SvrInfo.isNeedDebug()) {
                    LogSvr.getInstance().debug(string);
                }
                object.addBatch();
                if (++n2 != 100) continue;
                object.executeBatch();
                n2 = 0;
            }
            if (object != null && n2 > 0) {
                object.executeBatch();
            }
            dataTable.beforeFirst();
            if (object == null) return;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            object.close();
            throw throwable;
        }
        object.close();
    }
}

