/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.hotdeploy;

import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.hotdeploy.MidGlobalEnvState;
import com.bokesoft.yes.mid.hotdeploy.a;
import com.bokesoft.yigo.common.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class MidPluginManager {
    public static final String PLUGINS_A = "plugins_A";
    public static final String PLUGINS_B = "plugins_B";
    protected URLClassLoader pluginClassLoader = null;
    private String sourcePath = null;

    public MidPluginManager(String string) {
        this.sourcePath = string;
    }

    public void init() throws Throwable {
        if (this.sourcePath == null) {
            return;
        }
        File file = this.initAndCopyJars();
        this.initPluginsClassloader(file);
    }

    public void reload() throws Throwable {
        if (this.sourcePath == null) {
            return;
        }
        File file = this.copyJars();
        this.initPluginsClassloader(file);
    }

    private void initPluginsClassloader(File serializableArray) throws Throwable {
        if (serializableArray != null && serializableArray.exists() && serializableArray.isDirectory() && (serializableArray = serializableArray.listFiles(new a(this))) != null && serializableArray.length > 0) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (Serializable file : serializableArray) {
                arrayList.add(((File)file).toURI().toURL());
            }
            serializableArray = arrayList.toArray(new URL[0]);
            this.pluginClassLoader = new URLClassLoader((URL[])serializableArray, Thread.currentThread().getContextClassLoader());
        }
    }

    public URLClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    private File copyJars() throws IOException {
        Object object = SvrInfo.getWorkDir() + "tmp";
        File file = new File((String)object, PLUGINS_A);
        object = new File((String)object, PLUGINS_B);
        int n2 = MidGlobalEnvState.getPluginState();
        if (n2 == 1 || n2 == 0) {
            FileUtil.copyJars((File)new File(this.sourcePath), (File)object, (boolean)true);
            return object;
        }
        if (n2 == 2) {
            FileUtil.copyJars((File)new File(this.sourcePath), (File)file, (boolean)true);
            return file;
        }
        return null;
    }

    private File initAndCopyJars() throws IOException {
        if (!ServerSetting.getInstance().isSupportHotDeploy()) {
            return new File(this.sourcePath);
        }
        Object object = SvrInfo.getWorkDir() + "tmp";
        File file = new File((String)object, PLUGINS_A);
        object = new File((String)object, PLUGINS_B);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileUtil.copyJars((File)new File(this.sourcePath), (File)file, (boolean)true);
        MidGlobalEnvState.setPluginState(1);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        } else {
            FileUtils.cleanDirectory((File)object);
        }
        return file;
    }

    public static void deleteTmp() {
        Object object = MidGlobalEnv.getInstance();
        if (object != null) {
            object.unload();
        }
        if ((object = new File(SvrInfo.getWorkDir() + "tmp")).exists()) {
            FileUtils.deleteQuietly((File)object);
        }
        if ((object = new File(SvrInfo.getWorkDir() + "plugins")).exists()) {
            FileUtils.deleteQuietly((File)object);
        }
    }
}

