/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.event;

import com.bokesoft.yes.mid.event.Event;
import com.bokesoft.yes.mid.event.EventDispatcher$EventRegistrationException;
import com.bokesoft.yes.mid.event.EventListener;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class EventDispatcher {
    private final ConcurrentMap<Class<? extends Event>, CopyOnWriteArraySet<EventListener<? extends Event>>> subscribers = new ConcurrentHashMap<Class<? extends Event>, CopyOnWriteArraySet<EventListener<? extends Event>>>();

    public void register(EventListener<? extends Event> eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        try {
            Class<? extends Event> clazz = this.getEventType(eventListener);
            if (clazz == null) {
                throw new EventDispatcher$EventRegistrationException("Failed to get event type for listener");
            }
            this.registerSubscriberForEventType(eventListener, clazz);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new EventDispatcher$EventRegistrationException("Failed to get event type for listener", noSuchMethodException);
        }
    }

    private void registerSubscriberForEventType(EventListener<? extends Event> eventListener, Class<? extends Event> serializable) {
        Serializable serializable2 = (CopyOnWriteArraySet<EventListener<? extends Event>>)this.subscribers.get(serializable);
        if (serializable2 == null && (serializable = this.subscribers.put((Class<? extends Event>)serializable, (CopyOnWriteArraySet<EventListener<? extends Event>>)(serializable2 = new CopyOnWriteArraySet<EventListener<? extends Event>>()))) != null) {
            serializable2 = serializable;
        }
        serializable2.add(eventListener);
    }

    public void unregister(EventListener<? extends Event> eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        try {
            Serializable serializable = this.getEventType(eventListener);
            if (serializable == null) {
                throw new EventDispatcher$EventRegistrationException("Failed to get event type for listener");
            }
            if ((serializable = (CopyOnWriteArraySet)this.subscribers.get(serializable)) != null) {
                ((CopyOnWriteArraySet)serializable).remove(eventListener);
            }
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new EventDispatcher$EventRegistrationException("Failed to get event type for listener", noSuchMethodException);
        }
    }

    public void postEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        for (Class clazz : this.subscribers.keySet()) {
            if (!clazz.isAssignableFrom(event.getClass())) continue;
            EventDispatcher eventDispatcher = this;
            eventDispatcher.dispatch((CopyOnWriteArraySet)eventDispatcher.subscribers.get(clazz), event);
        }
    }

    protected void dispatch(CopyOnWriteArraySet<EventListener<? extends Event>> object, Event event) {
        object = ((CopyOnWriteArraySet)object).iterator();
        while (object.hasNext()) {
            ((EventListener)object.next()).handleEvent(event);
        }
    }

    protected Class<? extends Event> getEventType(EventListener<? extends Event> eventListener) throws NoSuchMethodException {
        return eventListener.getEventClass();
    }
}

