/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XuGuDBManager
extends GeneralDBManager {
    private static final String[] keyWord = new String[]{"ABORT", "ABOVE", "ABSOLUTE", "ACCESS", "ACCOUNT", "ACTION", "ADD", "AFTER", "AGGREGATE", "ALL", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", "AOVERLAPS", "APPEND", "ARCHIVELOG", "ARE", "ARRAY", "AS", "ASC", "AT", "AUDIT", "AUDITOR", "AUTHID", "AUTHORIZATION", "AUTO", "BACKUP", "BACKWARD", "BADFILE", "BCONTAINS", "BEFORE", "BEGIN", "BETWEEN", "BINARY", "BINTERSECTS", "BIT", "BLOCK", "BLOCKS", "BODY", "BOTH", "BOUND", "BOVERLAPS", "BREAK", "BUFFER_POOL", "BUILD", "BULK", "BWITHIN", "BY", "CACHE", "CALL", "CASCADE", "CASE", "CAST", "CATCH", "CATEGORY", "CHAIN", "CHAR", "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CHUNK", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLLECT", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "COMPLETE", "COMPRESS", "COMPUTE", "CONNECT", "CONSTANT", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTEXT", "CONTINUE", "COPY", "CORRESPONDING", "CREATE", "CREATEDB", "CREATEUSER", "CROSS", "CROSSES", "CUBE", "CURRENT", "CURSOR", "CYCLE", "DATABASE", "DATAFILE", "DATE", "DATETIME", "DAY", "DBA", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DECODE", "DECRYPT", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DELIMITED", "DELIMITERS", "DEMAND", "DESC", "DESCRIBE", "DETERMINISTIC", "DIR", "DISABLE", "DISASSEMBLE", "DISCORDFILE", "DISJOINT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DRIVEN", "DROP", "EACH", "ELEMENT", "ELSE", "ELSEIF", "ELSIF", "ENABLE", "ENCODING", "ENCRYPT", "ENCRYPTOR", "END", "ENDCASE", "ENDFOR", "ENDIF", "ENDLOOP", "EQUALS", "ESCAPE", "EVERY", "EXCEPT", "XCEPTION", "EXCEPTIONS", "EXCLUSIVE", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXPIRE", "EXPLAIN", "EXPORT", "EXTEND", "EXTERNAL", "EXTRACT", "FALSE", "FAST", "FETCH", "FIELD", "FIELDS", "FILTER", "FINAL", "FINALLY", "FIRST", "FLOAT", "FOLLOWING", "FOR", "FORALL", "FORCE", "FOREIGN", "FORWARD", "FOUND", "FREELIST", "FREELISTS", "FROM", "FULL", "FUNCTION", "GENERATED", "GET", "GLOBAL", "GOTO", "GRANT", "GREATEST", "GROUP", "GROUPING", "GROUPS", "HANDLER", "HASH", "HAVING", "HEAP", "HIDE", "HOTSPOT", "HOUR", "IDENTIFIED", "IDENTIFIER", "IDENTITY", "IF", "ILIKE", "IMMEDIATE", "IMPORT", "IN", "INCLUDE", "INCREMENT", "INDEX", "INDEXTYPE", "INDICATOR", "INDICES", "INHERITS", "INIT", "INITIAL", "INITIALLY", "INITRANS", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INSTANTIABLE", "INSTEAD", "INTERSECT", "INTERSECTS", "INTERVAL", "INTO", "IO", "IS", "ISNULL", "ISOLATION", "ISOPEN", "JOB", "JOIN", "KEEP", "KEY", "KEYSET", "LABEL", "LANGUAGE", "LAST", "LEADING", "LEAST", "LEAVE", "LEFT", "LEFTOF", "LENGTH", "LESS", "LEVEL", "LEVELS", "LEXER", "LIBRARY", "LIKE", "LIMIT", "LINK", "LIST", "LISTEN", "LOAD", "LOB", "LOCAL", "LOCATION", "LOCATOR", "LOCK", "LOGFILE", "LOGGING", "LOGIN", "LOGOUT", "LOOP", "LOVERLAPS", "MATCH", "MATERIALIZED", "MAX", "MAXEXTENTS", "MAXSIZE", "MAXTRANS", "MAXVALUE", "MAXVALUES", "MEMBER", "MEMORY", "MERGE", "MINEXTENTS", "MINUS", "MINUTE", "MINVALUE", "MISSING", "MODE", "MODIFY", "MONTH", "MOVEMENT", "NAME", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NESTED", "NEW", "NEWLINE", "NEXT", "NO", "NOARCHIVELOG", "NOAUDIT", "NOCACHE", "NOCOMPRESS", "NOCREATEDB", "NOCREATEUSER", "NOCYCLE", "NODE", "NOFORCE", "NOFOUND", "NOLOGGING", "NONE", "NOORDER", "NOPARALLEL", "NOT", "NOTFOUND", "NOTHING", "NOTIFY", "NOTNULL", "NOVALIDATE", "NOWAIT", "NULL", "NULLIF", "NULLS", "NUMBER", "NUMERIC", "NVARCHAR", "NVARCHAR2", "NVL", "NVL2", "OBJECT", "OF", "OFF", "OFFLINE", "OFFSET", "OIDINDEX", "OIDS", "OLD", "ON", "ONLINE", "ONLY", "OPEN", "OPERATOR", "OPTION", "OR", "ORDER", "ORGANIZATION", "OTHERVALUES", "OUT", "OUTER", "OVER", "OVERLAPS", "OWNER", "PACKAGE", "PARALLEL", "PARAMETERS", "PARTIAL", "PARTITION", "PARTITIONS", "PASSWORD", "PCTFREE", "PCTINCREASE", "PCTUSED", "PCTVERSION", "PERIOD", "POLICY", "PRAGMA", "PREBUILT", "PRECEDING", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIORITY", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "PROTECTED", "PUBLIC", "QUERY", "QUOTA", "RAISE", "RANGE", "RAW", "READ", "READS", "REBUILD", "RECOMPILE", "RECORD", "RECORDS", "RECYCLE", "REDUCED", "REF", "REFERENCES", "REFERENCING", "REFRESH", "REINDEX", "RELATIVE", "RENAME", "REPEATABLE", "REPLACE", "REPLICATION", "RESOURCE", "RESTART", "RESTORE", "RESTRICT", "RESULT", "RETURN", "RETURNING", "REVERSE", "REVOKE", "REWRITE", "RIGHT", "RIGHTOF", "ROLE", "ROLLBACK", "ROLLUP", "ROVERLAPS", "ROW", "ROWCOUNT", "ROWID", "ROWS", "ROWTYPE", "RULE", "RUN", "SAVEPOINT", "SCHEMA", "SCROLL", "SECOND", "SEGMENT", "SELECT", "SELF", "SEQUENCE", "SERIALIZABLE", "SESSION", "SET", "SETOF", "SETS", "SHARE", "SHOW", "SHUTDOWN", "SIBLINGS", "SIZE", "SLOW", "SNAPSHOT", "SOME", "SPATIAL", "SPLIT", "SSO", "STANDBY", "START", "STATEMENT", "STATIC", "STATISTICS", "STEP", "STOP", "STORAGE", "STORE", "STREAM", "SUBPARTITION", "SUBPARTITIONS", "SUBTYPE", "SUCCESSFUL", "SYNONYM", "SYSTEM", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", "TERMINATED", "THAN", "THEN", "THROW", "TIME", "TIMESTAMP", "TO", "TOP", "TOPOVERLAPS", "TOUCHES", "TRACE", "TRAILING", "TRAN", "TRANSACTION", "TRIGGER", "TRUE", "TRUNCATE", "TRUSTED", "TRY", "TYPE", "UNBOUNDED", "UNDER", "UNDO", "UNIFORM", "UNION", "UNIQUE", "UNLIMITED", "UNLISTEN", "UNLOCK", "UNPROTECTED", "UNTIL", "UOVERLAPS", "UPDATE", "USE", "USER", "USING", "VACUUM", "VALID", "VALIDATE", "VALUE", "VALUES", "VARCHAR", "VARCHAR2", "VARRAY ", "ARYING", "VERBOSE", "VERSION", "VIEW", "VOCABLE", "WAIT", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHIN", "WITHOUT", "WORK", "WRITE", "XML", "YEAR", "ZONE"};
    private Set<String> keySet = null;

    public XuGuDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    public String getTableExistCheckSql() {
        return "select count(TABLE_NAME) from user_tables where UPPER(table_name)=?";
    }

    public String getColumnCheckSql() {
        return "select column_name from user_columns where UPPER(table_name) =?";
    }

    public String getIndexCheckSql() {
        return "select user_indexes.index_name from user_indexes left join user_tables on user_indexes.table_id = user_tables.table_id  where UPPER(table_name) =?";
    }

    public String getIndexSearchSql() {
        return "select user_tables.table_name from user_indexes left join user_tables on user_indexes.table_id = user_tables.table_id where UPPER(index_name) =?";
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add (";
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + "," + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return (String)object + ")";
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " date ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " binary_double ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " blob ";
                break;
            }
            case 1009: {
                string = " int";
                break;
            }
            case 1011: {
                string = " clob ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1010: {
                string = " bigint";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728XuGuDBManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toUpperCase());
            }
        }
        if (this.keySet.contains(string.toUpperCase())) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
            for (int i2 = 0; i2 < keyWord.length; ++i2) {
                this.keySet.add(keyWord[i2].toUpperCase());
            }
        }
        if (this.keySet.contains(string.toUpperCase())) {
            return stringBuilder.append("\"").append(string).append("\"");
        }
        return stringBuilder.append(string);
    }

    public int getDBType() {
        return 16;
    }

    @Override
    public Object convert(Object object, int n2, int n3) throws Throwable {
        if (n3 == 101 && (n2 == 1006 || n2 == 1007 || n2 == 1005)) {
            return new BigDecimal((Double)object);
        }
        if (n3 == 100 && (n2 == 1007 || n2 == 1006 || n2 == 1005)) {
            return new BigDecimal(((Float)object).floatValue());
        }
        return super.convert(object, n2, n3);
    }

    @Override
    public int convertDataType(int n2) {
        if (n2 == 101) {
            return 1006;
        }
        if (n2 == 100) {
            return 1007;
        }
        return super.convertDataType(n2);
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string = "to_date('" + stringBuilder.toString() + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string;
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.insert(stringBuilder2.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd')";
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
                string2 = stringBuilder.toString();
                string2 = string + " like to_date('" + string2 + "','yyyy-mm-dd hh24:mi:ss')";
            }
            return string2;
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String charSequence, boolean bl, int n2, int n3) {
        if (charSequence != null && ((String)charSequence).length() != 0) {
            string = string + " order by " + (String)charSequence;
        }
        charSequence = new StringBuilder(string.length() + 100);
        PrepareSQL prepareSQL = new PrepareSQL();
        if (bl) {
            ((StringBuilder)charSequence).append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            ((StringBuilder)charSequence).append("select * from ( ");
        }
        ((StringBuilder)charSequence).append(string);
        if (bl) {
            ((StringBuilder)charSequence).append(" ) row_ ) where rownum_ > ? and rownum_ <= ? ");
            prepareSQL.addValue((Object)n2);
            prepareSQL.addValue((Object)n3);
        } else {
            ((StringBuilder)charSequence).append(" ) where rownum <= ?");
            prepareSQL.addValue((Object)n3);
        }
        prepareSQL.setSQL(((StringBuilder)charSequence).toString());
        return prepareSQL;
    }

    public String getTableStructSql() {
        return "select TABLE_NAME from user_tables";
    }

    public String getColumnStructSql() {
        return "select user_columns.col_name as column_name, user_tables.table_name as table_name from user_columns join user_tables on user_columns.table_id = user_tables.table_id";
    }

    public String getIndexStructSql() {
        return "select user_indexes.index_name,user_tables.table_name, '' as COLUMN_NAME, -1 as NON_UNIQUE, 0 as SEQ_IN_INDEX from user_indexes left join user_tables on user_indexes.table_id = user_tables.table_id";
    }

    public String getViewExistCheckSql() {
        return null;
    }

    public String getViewStructSql() {
        return "select view_name from user_views";
    }
}

