/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;

public class SqliteDBManager
extends GeneralDBManager {
    private static int i = 0;

    public SqliteDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
        ++i;
    }

    @Override
    public boolean checkTableExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getTableExistCheckSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string);
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public String searchIndex(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getIndexSearchSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string);
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                string = resultSet.getString(1);
                return string;
            }
            return null;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public HashSet<String> getIndexSet(String string) throws Throwable {
        String string2 = this.getIndexCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string);
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    @Override
    public HashSet<String> getTableColumnSet(String string) throws Throwable {
        string = this.getColumnCheckSql() + "(" + string + ")";
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string);
            resultSet = this.executeQuery(preparedStatement, string, null);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(2).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable metaSchemaTable, List<MetaSchemaColumn> object) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object = object.iterator();
        String string = "alter table " + this.keyWordEscape(metaSchemaTable.getKey()) + " add ";
        if (object.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object.next();
            string = string + this.getColumnDef(metaSchemaColumn);
            string = string + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object.next();
            string = string + ";alter table " + this.keyWordEscape(metaSchemaTable.getKey()) + " add " + this.getColumnDef(metaSchemaColumn);
            string = string + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return string;
    }

    @Override
    public int execPrepareUpdate(String string, Object ... objectArray) throws Throwable {
        return this.execPrepareUpdate(string, (QueryArguments)new NormalQueryArguments(objectArray));
    }

    private int execPrepareUpdate(String string, QueryArguments queryArguments) throws Throwable {
        int n2 = 0;
        try (Statement statement = null;){
            for (String string2 : string.split(";")) {
                statement = this.prepareStatement(string2);
                n2 = this.executeUpdate((PreparedStatement)statement, string, queryArguments);
            }
        }
        return n2;
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " integer ";
                break;
            }
            case 1002: {
                string = " text(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1003: {
                string = " datetime ";
                break;
            }
            case 1004: {
                string = " datetime ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " real ";
                break;
            }
            case 1007: {
                string = " real ";
                break;
            }
            case 1008: {
                string = " blob ";
                break;
            }
            case 1009: {
                string = " numeric ";
                break;
            }
            case 1010: {
                string = " integer ";
                break;
            }
            case 1011: {
                string = " text ";
                break;
            }
            case 1012: {
                string = " text(" + metaSchemaColumn.getLength() + ") ";
                break;
            }
            case 1101: {
                string = " numeric ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728SqliteDBManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    @Override
    public Object convert(Object object, int n2, int n3) throws Throwable {
        if (object != null) {
            if (n2 == 1005) {
                return TypeConvertor.toBigDecimal((Object)object);
            }
            return super.convert(object, n2, n3);
        }
        return null;
    }

    public String keyWordEscape(String string) {
        return "`" + string + "`";
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        return stringBuilder.append("`").append(string).append("`");
    }

    public int getDBType() {
        return 7;
    }

    @Override
    public void close() throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (i > 0) {
            --i;
            return;
        }
    }

    @Override
    public void commit() throws SQLException {
        if (i == 1) {
            this.connection.commit();
        }
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.insert(stringBuilder2.length(), "'").insert(6, "-").insert(4, "-").insert(0, "'");
            } else {
                StringBuilder stringBuilder3 = stringBuilder;
                stringBuilder3.insert(stringBuilder3.length(), "'").insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-").insert(0, "'");
            }
            return stringBuilder.toString();
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder4 = stringBuilder;
        stringBuilder4.insert(stringBuilder4.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
            }
            string2 = stringBuilder.toString();
            return string + " like '%" + string2 + "%'";
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String string2, boolean bl, int n2, int n3) {
        boolean bl2 = string2 != null && string2.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" order by ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(bl ? " limit ?, ?" : " limit ?");
        string = new PrepareSQL();
        string.setSQL(stringBuilder.toString());
        if (bl) {
            string.addValue((Object)n2);
            string.addValue((Object)(n3 - n2));
        } else {
            string.addValue((Object)n3);
        }
        return string;
    }

    public String getTableExistCheckSql() {
        return "Select count(*) from sqlite_master WHERE type = 'table' and name = ? COLLATE NOCASE";
    }

    public String getIndexSearchSql() {
        return "Select tbl_name from sqlite_master WHERE type = 'index' and name = ? COLLATE NOCASE";
    }

    public String getIndexCheckSql() {
        return "Select name from sqlite_master WHERE type = 'index' and tbl_name = ? COLLATE NOCASE";
    }

    public String getColumnCheckSql() {
        return "PRAGMA table_info";
    }

    public String getTableStructSql() {
        return "Select name from sqlite_master WHERE type = 'table'";
    }

    public String getColumnStructSql() {
        return "PRAGMA table_info";
    }

    public String getIndexStructSql() {
        return "Select name,tbl_name, '' as COLUMN_NAME, -1 as NON_UNIQUE, 0 as SEQ_IN_INDEX from sqlite_master WHERE type = 'index'";
    }

    @Override
    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        PreparedStatement preparedStatement;
        block6: {
            String string = this.getTableStructSql();
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, null);
                dataBaseInfo.initTable(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getTableStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, null);
                while (resultSet.next()) {
                    string = resultSet.getString(1).toUpperCase();
                    Object object = this.getColumnStructSql() + "(" + string + ")";
                    PreparedStatement preparedStatement2 = this.prepareStatement((String)object);
                    object = this.executeQuery(preparedStatement2, (String)object, null);
                    dataBaseInfo.initColumn((ResultSet)object, string);
                    preparedStatement2.close();
                    object.close();
                }
                preparedStatement.close();
                resultSet.close();
                string = this.getIndexStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, null);
                dataBaseInfo.initIndex(resultSet);
                if (resultSet == null) break block6;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }

    public String getViewExistCheckSql() {
        return null;
    }

    public String getViewStructSql() {
        return null;
    }
}

