/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class SqlServerDBManager
extends GeneralDBManager {
    private static int mainVersion = -1;

    public SqlServerDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    public String getViewExistCheckSql() {
        return "select count(name) count from sys.views where name=? and type=? ";
    }

    public String getTableExistCheckSql() {
        return "select count(name) count from sys.tables where name=? and type=? ";
    }

    public String getColumnCheckSql() {
        return "select name from syscolumns where id=(select id from sysobjects where xtype=? and name=?)";
    }

    public String getIndexCheckSql() {
        return "select name from sysindexes where id=(select id from sysobjects where xtype=? and name=?)";
    }

    public String getIndexSearchSql() {
        return "select name from sysobjects where id=(select id from sysindexes where name=?)";
    }

    @Override
    public HashSet<String> getIndexSet(String string) throws Throwable {
        String string2 = this.getIndexCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)"U");
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                string = resultSet.getString(1);
                if (string == null || string.length() <= 0) continue;
                hashSet.add(string.toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                String string2;
                String string3;
                string = " nvarchar(" + metaSchemaColumn.getLength() + ") ";
                if (!metaSchemaColumn.isCaseSensitive() || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{string3 = DBManagerUtil.getSqlserverCollation(), string2 = DBManagerUtil.getSqlserverCaseSensitiveCollation()}) || StringUtils.equalsIgnoreCase((CharSequence)string3, (CharSequence)string2)) break;
                string = string + "collate " + string2 + " ";
                break;
            }
            case 1003: {
                string = " datetime ";
                break;
            }
            case 1004: {
                string = " datetime ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " float ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " varbinary(max) ";
                break;
            }
            case 1009: {
                string = " int";
                break;
            }
            case 1010: {
                string = " bigint ";
                break;
            }
            case 1011: {
                string = " nvarchar(max) ";
                break;
            }
            case 1012: {
                String string4;
                String string5;
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                if (!metaSchemaColumn.isCaseSensitive() || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{string5 = DBManagerUtil.getSqlserverCollation(), string4 = DBManagerUtil.getSqlserverCaseSensitiveCollation()}) || StringUtils.equalsIgnoreCase((CharSequence)string5, (CharSequence)string4)) break;
                string = string + "collate " + string4 + " ";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728SqlServerDBManager\u4e2d\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        return "[" + string + "]";
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        return stringBuilder.append("[").append(string).append("]");
    }

    public int getDBType() {
        return 1;
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.insert(stringBuilder2.length(), "'").insert(6, "-").insert(4, "-").insert(0, "'");
            } else {
                StringBuilder stringBuilder3 = stringBuilder;
                stringBuilder3.insert(stringBuilder3.length(), "'").insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-").insert(0, "'");
            }
            return stringBuilder.toString();
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder4 = stringBuilder;
        stringBuilder4.insert(stringBuilder4.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
            }
            string2 = stringBuilder.toString();
            return "convert(varchar," + string + ",120) like '%" + string2 + "%'";
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String string2, boolean bl, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 100);
        boolean bl2 = string2 != null && string2.length() != 0;
        PrepareSQL prepareSQL = new PrepareSQL();
        if (bl) {
            stringBuilder.append("select * from ( select tb1_.* , ROW_NUMBER() over( ");
            stringBuilder.append("order by ");
            stringBuilder.append(bl2 ? string2 : "(select 1)");
            stringBuilder.append(") as rownumber_ from (");
            stringBuilder.append(string);
            stringBuilder.append(" ) tb1_ ) tb2_ where rownumber_ > ? and rownumber_ <= ? ");
            prepareSQL.addValue((Object)n2);
            prepareSQL.addValue((Object)n3);
        } else {
            stringBuilder.append("select * from ( select tb1_.* , ROW_NUMBER() over( ");
            stringBuilder.append("order by ");
            stringBuilder.append(bl2 ? string2 : "(select 1)");
            stringBuilder.append(") as rownumber_ from (");
            stringBuilder.append(string);
            stringBuilder.append(" ) tb1_ ) tb2_ where rownumber_ <= ? ");
            prepareSQL.addValue((Object)n3);
        }
        prepareSQL.setSQL(stringBuilder.toString());
        return prepareSQL;
    }

    public int getMainVersion() throws Throwable {
        if (mainVersion < 0) {
            String string;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                string = "select cast (SERVERPROPERTY('productversion')  as varchar(100))";
                statement = this.connection.prepareStatement(string, 1004, 1007);
                resultSet = this.executeQuery((PreparedStatement)statement, string, null);
                resultSet.next();
                string = resultSet.getString(1);
                string = string.substring(0, string.indexOf(46));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            mainVersion = TypeConvertor.toInteger((Object)string);
        }
        return mainVersion;
    }

    @Override
    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        PreparedStatement preparedStatement;
        block5: {
            String string = this.getTableStructSql();
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg("u");
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initTable(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getViewStructSql();
                preparedStatement = this.prepareStatement(string);
                pSArgs = new PSArgs();
                pSArgs.addStringArg("v");
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initView(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getColumnStructSql();
                preparedStatement = this.prepareStatement(string);
                pSArgs = new PSArgs();
                pSArgs.addStringArg("U");
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initColumn(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getIndexStructSql();
                preparedStatement = this.prepareStatement(string);
                pSArgs = new PSArgs();
                pSArgs.addStringArg("U");
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initIndex(resultSet);
                if (resultSet == null) break block5;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }

    @Override
    public boolean checkViewExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getViewExistCheckSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addStringArg("v");
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public boolean checkTableExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getTableExistCheckSql();
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            pSArgs.addStringArg("u");
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public HashSet<String> getTableColumnSet(String string) throws Throwable {
        String string2 = this.getColumnCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.prepareStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addStringArg("U");
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toUpperCase());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    public String getTableStructSql() {
        return "select name count from sys.tables where type=? ";
    }

    public String getColumnStructSql() {
        return "select syscolumns.name,sysobjects.name,syscolumns.xtype,syscolumns.xprec,syscolumns.xscale,syscolumns.length from syscolumns join sysobjects on syscolumns.id=sysobjects.id where sysobjects.xtype=? ";
    }

    public String getIndexStructSql() {
        return "select sysindexes.name,sysobjects.name, '' as COLUMN_NAME, -1 as NON_UNIQUE, 0 as SEQ_IN_INDEX from sysindexes join sysobjects on sysindexes.id=sysobjects.id where sysobjects.xtype=?  and sysindexes.name is  not null";
    }

    public String getViewStructSql() {
        return "select name count from sys.views where type=? ";
    }
}

