/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;

public class MySqlDBManager
extends GeneralDBManager {
    private static final int FETCH_SIZE = 100;

    public MySqlDBManager(IConnectionProfile iConnectionProfile, Connection connection) {
        super(iConnectionProfile, connection);
    }

    @Override
    public boolean checkViewExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getViewExistCheckSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toLowerCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getCatalog());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public boolean checkTableExist(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getTableExistCheckSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toLowerCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getCatalog());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            resultSet.next();
            boolean bl = resultSet.getInt(1) == 1;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    @Override
    public HashSet<String> getTableColumnSet(String string) throws Throwable {
        String string2 = this.getColumnCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toLowerCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getCatalog());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    public String getViewExistCheckSql() {
        if (DBManagerUtil.isLowerCaseTableNames()) {
            return "select count(TABLE_NAME) count from information_schema.`VIEWS` WHERE TABLE_NAME = ?  and TABLE_SCHEMA = ?";
        }
        return "select count(TABLE_NAME) count from information_schema.`VIEWS` WHERE LOWER(TABLE_NAME) = ?  and TABLE_SCHEMA = ?";
    }

    public String getTableExistCheckSql() {
        if (DBManagerUtil.isLowerCaseTableNames()) {
            return "select count(TABLE_NAME) count from information_schema.`TABLES` WHERE TABLE_NAME = ?  and TABLE_SCHEMA = ?";
        }
        return "select count(TABLE_NAME) count from information_schema.`TABLES` WHERE LOWER(TABLE_NAME) = ?  and TABLE_SCHEMA = ?";
    }

    @Override
    public HashSet<String> getIndexSet(String string) throws Throwable {
        String string2 = this.getIndexCheckSql();
        HashSet<String> hashSet = new HashSet<String>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toLowerCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getCatalog());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                hashSet.add(resultSet.getString(1).toUpperCase());
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return hashSet;
    }

    @Override
    public String searchIndex(String string) throws Throwable {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string2 = this.getIndexSearchSql();
            preparedStatement = this.preparedQueryStatement(string2);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addArg(Integer.valueOf(1002), (Object)string.toLowerCase());
            pSArgs.addArg(Integer.valueOf(1002), (Object)this.connection.getCatalog());
            resultSet = this.executeQuery(preparedStatement, string2, (QueryArguments)pSArgs);
            if (resultSet.next()) {
                string = resultSet.getString(1);
                return string;
            }
            return null;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public String getIndexSearchSql() {
        if (DBManagerUtil.isLowerCaseTableNames()) {
            return "select TABLE_NAME from information_schema.STATISTICS where INDEX_NAME=?   and TABLE_SCHEMA = ?";
        }
        return "select TABLE_NAME from information_schema.STATISTICS where LOWER(INDEX_NAME)=?   and TABLE_SCHEMA = ?";
    }

    public String getColumnCheckSql() {
        if (DBManagerUtil.isLowerCaseTableNames()) {
            return "select COLUMN_NAME from information_schema.COLUMNS where TABLE_NAME=?   and TABLE_SCHEMA = ?";
        }
        return "select COLUMN_NAME from information_schema.COLUMNS where LOWER(TABLE_NAME)=?   and TABLE_SCHEMA = ?";
    }

    public String getIndexCheckSql() {
        if (DBManagerUtil.isLowerCaseTableNames()) {
            return "select INDEX_NAME, COLUMN_NAME, NON_UNIQUE from information_schema.STATISTICS where TABLE_NAME=?   and TABLE_SCHEMA = ? order by INDEX_NAME,SEQ_IN_INDEX";
        }
        return "select INDEX_NAME, COLUMN_NAME, NON_UNIQUE from information_schema.STATISTICS where LOWER(TABLE_NAME)=?   and TABLE_SCHEMA = ? order by INDEX_NAME,SEQ_IN_INDEX";
    }

    @Override
    public String getAlterTableStr(MetaSchemaTable object, List<MetaSchemaColumn> object2) throws Throwable {
        MetaSchemaColumn metaSchemaColumn;
        object2 = object2.iterator();
        object = "alter table " + this.keyWordEscape(object.getKey()) + " add (";
        if (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        while (object2.hasNext()) {
            metaSchemaColumn = (MetaSchemaColumn)object2.next();
            object = (String)object + "," + this.getColumnDef(metaSchemaColumn);
            object = (String)object + this.getDefaultValueString(metaSchemaColumn.getDataType(), metaSchemaColumn.getDefaultValue());
        }
        return (String)object + ")";
    }

    public String getColumnDef(MetaSchemaColumn metaSchemaColumn) throws Throwable {
        String string;
        switch (metaSchemaColumn.getDataType()) {
            case 1001: {
                string = " int ";
                break;
            }
            case 1002: {
                string = " varchar(" + metaSchemaColumn.getLength() + ") ";
                if (!metaSchemaColumn.isCaseSensitive()) break;
                string = string + "binary ";
                break;
            }
            case 1003: {
                string = " date ";
                break;
            }
            case 1004: {
                string = " datetime ";
                break;
            }
            case 1005: {
                string = " numeric(" + metaSchemaColumn.getPrecision() + "," + metaSchemaColumn.getScale() + ") ";
                break;
            }
            case 1006: {
                string = " double ";
                break;
            }
            case 1007: {
                string = " float ";
                break;
            }
            case 1008: {
                string = " long varbinary ";
                break;
            }
            case 1009: {
                string = " int ";
                break;
            }
            case 1010: {
                string = " bigint ";
                break;
            }
            case 1011: {
                string = " mediumtext ";
                break;
            }
            case 1012: {
                string = " char(" + metaSchemaColumn.getLength() + ") ";
                if (!metaSchemaColumn.isCaseSensitive()) break;
                string = string + "binary ";
                break;
            }
            case 1101: {
                string = " timestamp ";
                break;
            }
            default: {
                throw new MidCoreException(6, "\u6570\u636e\u7c7b\u578b" + DataType.toString((Integer)metaSchemaColumn.getDataType()) + "\u5728MySqlDBManager\u672a\u5b9a\u4e49\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5217\u7c7b\u578b\uff01");
            }
        }
        return this.keyWordEscape(metaSchemaColumn.getKey()) + string;
    }

    public String keyWordEscape(String string) {
        return "`" + string + "`";
    }

    public StringBuilder appendKeyWordEscape(StringBuilder stringBuilder, String string) {
        return stringBuilder.append("`").append(string).append("`");
    }

    public int getDBType() {
        return 4;
    }

    public String getConditionValue(int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string = string.replaceAll("\\D+", "");
            stringBuilder.append(string);
            if (stringBuilder.length() == 8) {
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.insert(stringBuilder2.length(), "'").insert(6, "-").insert(4, "-").insert(0, "'");
            } else {
                StringBuilder stringBuilder3 = stringBuilder;
                stringBuilder3.insert(stringBuilder3.length(), "'").insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-").insert(0, "'");
            }
            return stringBuilder.toString();
        }
        stringBuilder.append(string);
        StringBuilder stringBuilder4 = stringBuilder;
        stringBuilder4.insert(stringBuilder4.length(), "'").insert(0, "'");
        return stringBuilder.toString();
    }

    public String getLikeConditionValue(String string, int n2, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 1004) {
            string2 = string2.replaceAll("\\D+", "");
            stringBuilder.append(string2);
            if (stringBuilder.length() == 8) {
                stringBuilder.insert(6, "-").insert(4, "-");
            } else {
                stringBuilder.insert(12, ":").insert(10, ":").insert(8, " ").insert(6, "-").insert(4, "-");
            }
            string2 = stringBuilder.toString();
            return string + " like '%" + string2 + "%'";
        }
        return string + " like " + string2;
    }

    public PrepareSQL getLimitString(String string, String string2, boolean bl, int n2, int n3) {
        boolean bl2 = string2 != null && string2.length() != 0;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 50);
        stringBuilder.append(string);
        if (bl2) {
            stringBuilder.append(" order by ");
            stringBuilder.append(string2);
        }
        stringBuilder.append(bl ? " limit ?, ?" : " limit ?");
        string = new PrepareSQL();
        string.setSQL(stringBuilder.toString());
        if (bl) {
            string.addValue((Object)n2);
            string.addValue((Object)(n3 - n2));
        } else {
            string.addValue((Object)n3);
        }
        return string;
    }

    @Override
    protected PreparedStatement prepareStatement(String object) throws SQLException {
        object = super.prepareStatement((String)object);
        object.setFetchSize(100);
        return object;
    }

    public String getTableStructSql() {
        return "select TABLE_NAME from information_schema.`TABLES` WHERE TABLE_SCHEMA = ?";
    }

    public String getColumnStructSql() {
        return "select COLUMN_NAME,TABLE_NAME,DATA_TYPE,NUMERIC_PRECISION,NUMERIC_SCALE,CHARACTER_MAXIMUM_LENGTH from information_schema.COLUMNS where TABLE_SCHEMA = ?";
    }

    public String getIndexStructSql() {
        return "select INDEX_NAME,TABLE_NAME,COLUMN_NAME,NON_UNIQUE,SEQ_IN_INDEX from information_schema.STATISTICS where TABLE_SCHEMA = ? order by TABLE_NAME,INDEX_NAME,SEQ_IN_INDEX";
    }

    public String getViewStructSql() {
        return "select TABLE_NAME from information_schema.`VIEWS` WHERE TABLE_SCHEMA = ?";
    }

    @Override
    public void initDataBaseInfo(DataBaseInfo dataBaseInfo) throws Throwable {
        PreparedStatement preparedStatement;
        block5: {
            String string = this.getTableStructSql();
            preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addStringArg(this.connection.getCatalog());
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initTable(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getViewStructSql();
                preparedStatement = this.prepareStatement(string);
                pSArgs = new PSArgs();
                pSArgs.addStringArg(this.connection.getCatalog());
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initView(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getColumnStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initColumn(resultSet);
                preparedStatement.close();
                resultSet.close();
                string = this.getIndexStructSql();
                preparedStatement = this.prepareStatement(string);
                resultSet = this.executeQuery(preparedStatement, string, (QueryArguments)pSArgs);
                dataBaseInfo.initIndex(resultSet);
                if (resultSet == null) break block5;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }
}

