/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection;

import com.bokesoft.yes.mid.connection.DbcpConnectionFactory;
import com.bokesoft.yes.mid.connection.JdbcConnectionFactory;
import com.bokesoft.yes.mid.connection.SqliteConnectionFactory;
import com.bokesoft.yes.mid.connection.dbmanager.DB2DBManager;
import com.bokesoft.yes.mid.connection.dbmanager.DMDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.EsgynDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.GaussDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.HighGoDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.KingbaseManager;
import com.bokesoft.yes.mid.connection.dbmanager.MyCatDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.MySqlClusterDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.MySqlDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.OracleDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.PostgreSQLDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.ShenTongDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.SqlServerDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.SqliteDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.XuGuDBManager;
import com.bokesoft.yigo.mid.connection.IConnectionFactory;
import com.bokesoft.yigo.mid.connection.IConnectionProfile;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.connection.IDBManagerFactory;
import java.sql.Connection;

public class DBManagerFactory
implements IDBManagerFactory {
    public IDBManager getDBManager(IConnectionProfile iConnectionProfile) throws Throwable {
        GeneralDBManager generalDBManager = null;
        IConnectionFactory iConnectionFactory = null;
        int n2 = iConnectionProfile.getDBType();
        Object object = iConnectionProfile.getConnectionFactoryClazz();
        if (object != null && !((String)object).isEmpty()) {
            iConnectionFactory = (IConnectionFactory)Class.forName((String)object).newInstance();
        }
        if (iConnectionFactory == null) {
            if (n2 == 7) {
                iConnectionFactory = new SqliteConnectionFactory();
            } else {
                switch (iConnectionProfile.getConnectionType()) {
                    case 0: {
                        iConnectionFactory = new JdbcConnectionFactory();
                        break;
                    }
                    case 1: {
                        iConnectionFactory = new DbcpConnectionFactory();
                    }
                }
            }
        }
        if (iConnectionFactory != null) {
            object = iConnectionFactory.getConnection(iConnectionProfile);
            object.setAutoCommit(false);
            switch (n2) {
                case 1: {
                    generalDBManager = new SqlServerDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 2: {
                    generalDBManager = new OracleDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 3: {
                    generalDBManager = new DB2DBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 4: {
                    generalDBManager = new MySqlDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 6: {
                    generalDBManager = new MySqlClusterDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 9: {
                    generalDBManager = new MyCatDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 8: {
                    generalDBManager = new DMDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 7: {
                    generalDBManager = new SqliteDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 11: {
                    generalDBManager = new HighGoDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 10: {
                    generalDBManager = new PostgreSQLDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 12: {
                    generalDBManager = new GaussDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 13: {
                    generalDBManager = new KingbaseManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 15: {
                    generalDBManager = new ShenTongDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 14: {
                    generalDBManager = new EsgynDBManager(iConnectionProfile, (Connection)object);
                    break;
                }
                case 16: {
                    generalDBManager = new XuGuDBManager(iConnectionProfile, (Connection)object);
                }
            }
            if (generalDBManager != null) {
                generalDBManager.setKey(iConnectionProfile.getKey());
            }
        }
        return generalDBManager;
    }
}

