/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.rights;

import com.bokesoft.yes.common.encrypt.RSA;
import com.bokesoft.yes.common.encrypt.SaltHash;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.mid.certificate.utils.MidPasswordRuleChecker;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.rights.OperatorRightsUtil;
import com.bokesoft.yes.mid.service.ServiceSecurityException;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.auth.IAuthLogProcess;
import com.bokesoft.yigo.mid.auth.IChangePWDProcess;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.para.SysPara;
import com.bokesoft.yigo.tools.ve.VE;
import java.sql.PreparedStatement;
import java.util.ServiceLoader;
import org.apache.commons.codec.binary.Hex;

public class ChangePWDCmd
extends DefaultServiceCmd {
    private long operatorID = 0L;
    private String password = "";
    private String newPassword = "";
    private static ServiceLoader<IAuthLogProcess> authLogProcesses = ServiceLoader.load(IAuthLogProcess.class);

    public void setOperatorID(long l2) {
        this.operatorID = l2;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.operatorID = TypeConvertor.toLong((Object)stringHashMap.get((Object)"operatorID"));
        this.password = TypeConvertor.toString((Object)stringHashMap.get((Object)"password"));
        this.newPassword = TypeConvertor.toString((Object)stringHashMap.get((Object)"newPassword"));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        String string;
        MetaLoginSetting metaLoginSetting;
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        MetaTable metaTable = (MetaTable)iMetaFactory.getDataObject("Operator").getTableCollection().get("SYS_Operator");
        MetaColumn metaColumn = metaTable.getOIDColumn();
        MetaColumn metaColumn2 = (MetaColumn)metaTable.get("Password");
        MetaColumn metaColumn3 = (MetaColumn)metaTable.get("Name");
        Object object = defaultContext.getVE().getEnv();
        Object object2 = defaultContext.getVE();
        MetaSetting metaSetting = iMetaFactory.getSetting();
        IChangePWDProcess iChangePWDProcess = null;
        if (metaSetting != null && (metaLoginSetting = metaSetting.getLogin()) != null && (string = metaLoginSetting.getChangePwdProcess()) != null && !string.isEmpty()) {
            iChangePWDProcess = (IChangePWDProcess)ReflectHelper.newInstance((VE)object2, (String)string);
        }
        long l2 = object.getUserID();
        String string2 = metaColumn2.getBindingDBColumnName();
        metaColumn2 = defaultContext.getDBManager();
        object = null;
        object2 = null;
        RSA rSA = new RSA();
        String string3 = SysPara.getInstance().get("PrivateKey");
        try {
            Object object3;
            if (l2 == this.operatorID) {
                void var6_17;
                void var6_14;
                string = String.format("select %s,%s,%s from %s where %s = ?", metaColumn.getBindingDBColumnName(), metaColumn3.getBindingDBColumnName(), string2, metaTable.getBindingDBTableName(), metaColumn.getBindingDBColumnName());
                object = metaColumn2.preparedQueryStatement(string);
                PSArgs pSArgs = new PSArgs();
                pSArgs.addLongArg(Long.valueOf(this.operatorID));
                object2 = metaColumn2.executeQuery((PreparedStatement)object, string, (QueryArguments)pSArgs);
                if (!object2.next()) throw new SessionException(1, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)1, (Object[])new Object[0]));
                String string4 = object2.getString(string2);
                object3 = this.decodePassword(rSA, this.password, string3);
                if (this.isHashEncrypt(defaultContext)) {
                    boolean bl = this.hashCheck((String)object3, string4);
                } else {
                    boolean bl = this.rsaCheck(rSA, (String)object3, string4, string3);
                }
                if (var6_14 == false) {
                    throw new SessionException(1, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)1, (Object[])new Object[0]));
                }
                if (this.isHashEncrypt(defaultContext)) {
                    String string5 = this.getNewPasswordHash(rSA, string3);
                } else {
                    String string6 = this.getNewPasswordRSA(defaultContext, rSA, string3);
                }
                String string7 = String.format("update %s set %s = ? where %s = ? ", metaTable.getBindingDBTableName(), string2, metaColumn.getBindingDBColumnName());
                metaColumn2.execPrepareUpdate(string7, new Object[]{var6_17, this.operatorID});
            } else {
                void var6_20;
                if (!OperatorRightsUtil.isAdmin((DefaultContext)defaultContext)) throw new ServiceSecurityException(2, ServiceSecurityException.formatMessage((ILocale)defaultContext.getEnv(), (int)2, (Object[])new Object[0]));
                if (this.isHashEncrypt(defaultContext)) {
                    String string8 = this.getNewPasswordHash(rSA, string3);
                } else {
                    String string9 = this.getNewPasswordRSA(defaultContext, rSA, string3);
                }
                object3 = String.format("update %s set %s = ? where %s = ? ", metaTable.getBindingDBTableName(), string2, metaColumn.getBindingDBColumnName());
                metaColumn2.execPrepareUpdate((String)object3, new Object[]{var6_20, this.operatorID});
            }
            object3 = authLogProcesses.iterator();
            while (object3.hasNext()) {
                void var6_21;
                ((IAuthLogProcess)object3.next()).postChangePWD(defaultContext, this.operatorID, (String)var6_21);
            }
        }
        catch (Throwable throwable) {
            if (iChangePWDProcess == null) throw throwable;
            iChangePWDProcess.failed((IServiceContext)defaultContext, throwable);
            throw throwable;
        }
        finally {
            if (object != null) {
                object.close();
            }
            if (object2 != null) {
                object2.close();
            }
        }
        if (iChangePWDProcess == null) return Boolean.TRUE;
        iChangePWDProcess.success((IServiceContext)defaultContext);
        return Boolean.TRUE;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ChangePWDCmd();
    }

    public String getCmd() {
        return "ChangePWD";
    }

    private boolean isHashEncrypt(DefaultContext defaultContext) {
        return (defaultContext = defaultContext.getVE().getMetaFactory().getSetting()) != null && defaultContext.getLogin() != null && defaultContext.getLogin().getEncryptType() == 2;
    }

    private boolean rsaCheck(RSA object, String string, String object2, String string2) throws Exception {
        object2 = Base64.decode((byte[])((String)object2).getBytes());
        object2 = object.decryptByPrivate((byte[])object2, string2);
        object = new String((byte[])object2);
        return string.equals(object);
    }

    private boolean hashCheck(String string, String string2) throws Exception {
        return SaltHash.validatePassword((String)string, (String)string2);
    }

    private String decodePassword(RSA rSA, String object, String string) throws Exception {
        object = Base64.decode((byte[])((String)object).getBytes());
        object = Hex.decodeHex((char[])new String((byte[])object).toCharArray());
        object = rSA.decryptByPrivate((byte[])object, string);
        return new String((byte[])object);
    }

    private String getNewPasswordRSA(DefaultContext defaultContext, RSA object, String string) throws Throwable {
        byte[] byArray = Base64.decode((byte[])this.newPassword.getBytes());
        byte[] byArray2 = Hex.decodeHex((char[])new String(byArray).toCharArray());
        byArray = object.decryptByPrivate(byArray2, string);
        object = new String(byArray);
        MidPasswordRuleChecker.getInstance().check((String)object, defaultContext.getEnv().getLocale(), (Object)defaultContext);
        return new String(Base64.encode((byte[])byArray2));
    }

    private String getNewPasswordHash(RSA rSA, String string) throws Throwable {
        return SaltHash.createHash((String)this.decodePassword(rSA, this.newPassword, string));
    }

    public boolean getNeedServiceRight() {
        return true;
    }
}

