/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.timer;

import com.bokesoft.yes.mid.timer.WorkingCalendarCounter;
import com.bokesoft.yigo.meta.calendar.MetaWorkingCalendar;
import com.bokesoft.yigo.meta.timer.MetaTimerTask;
import com.bokesoft.yigo.meta.timer.period.Moment;
import com.bokesoft.yigo.meta.timer.period.Period;
import com.bokesoft.yigo.meta.timer.period.WorkDay;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import java.util.Calendar;

public abstract class AbstractTimerTask {
    private long date = -1L;

    public abstract IServiceContext createContext();

    public abstract Object doAction(IServiceContext var1) throws Throwable;

    public AbstractTimerTask(IServiceContext iServiceContext, MetaTimerTask metaTimerTask) throws Throwable {
        this.initDate(metaTimerTask.getPeriod(), iServiceContext);
    }

    private void initDate(Period period, IServiceContext object) throws Throwable {
        if (period instanceof Moment) {
            period = (Moment)period;
            object = Calendar.getInstance();
            ((Calendar)object).add(10, period.getHour());
            ((Calendar)object).add(12, period.getMinute());
            ((Calendar)object).add(13, period.getSecond());
            this.date = ((Calendar)object).getTimeInMillis();
            return;
        }
        if (period instanceof WorkDay) {
            period = (WorkDay)period;
            object = (MetaWorkingCalendar)((DefaultContext)object).getVE().getMetaFactory().getSolution().getWorkingCalendarCollection().get("Default");
            object = new WorkingCalendarCounter((MetaWorkingCalendar)object);
            this.date = ((WorkingCalendarCounter)object).dayOff(period.getDayCount()).getTime();
        }
    }

    public boolean dealException(IServiceContext iServiceContext, Throwable throwable) {
        throwable.printStackTrace();
        return false;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long l) {
        this.date = l;
    }
}

