/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.specificCache;

import com.bokesoft.yes.mid.cache.CacheDBTable;
import com.bokesoft.yes.mid.cache.Row;
import com.bokesoft.yes.mid.cache.RowKey;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.specificCache.Column;
import com.bokesoft.yes.mid.specificCache.MetaData;
import com.bokesoft.yes.mid.specificCache.SpecificRow;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.function.Consumer;

public class SpecificCacheTable<T extends SpecificRow>
extends CacheDBTable<T> {
    private ArrayList<T> rowList = new ArrayList();
    private TreeMap<RowKey, T> rowMap = new TreeMap();
    private MetaData metaData = new MetaData();

    public void load(IDBManager object, PreparedStatement preparedStatement) throws Throwable {
        block6: {
            this.rowList.clear();
            this.rowMap.clear();
            object = null;
            try {
                object = preparedStatement.executeQuery();
                while (object.next()) {
                    T t = this.createNewEmptyRow();
                    this.loadRow(t, (ResultSet)object);
                    ((Row)((Object)t)).setNormalAfterLoad();
                    this.internalAddRow(t);
                }
                if (object == null) break block6;
            }
            catch (Throwable throwable) {
                if (object != null) {
                    object.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            object.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
            return;
        }
    }

    protected T createNewEmptyRow() {
        return null;
    }

    protected void loadRow(T t, ResultSet resultSet) throws Throwable {
        Class<?> clazz = t.getClass();
        int n = 1;
        for (Column column : this.metaData.getColumnList()) {
            if (column.isLoad()) {
                String string = this.getMethodName(column.getColumnName(), "set");
                clazz.getDeclaredField(string).set(t, resultSet.getObject(n));
            }
            ++n;
        }
    }

    @Override
    public PsPara getLoadPreparedStatement(IDBManager iDBManager) throws Throwable {
        return null;
    }

    @Override
    public PsPara createDeletePreparedStatement(IDBManager iDBManager) throws Throwable {
        String string = "delete from " + iDBManager.keyWordEscape(this.metaData.getTableName()) + " where ";
        for (Column column : this.metaData.getColumnList()) {
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + " = ? and ";
        }
        string = string.substring(0, string.length() - 4);
        return new PsPara(iDBManager.preparedUpdateStatement(string), string);
    }

    @Override
    public PsPara createUpdatePreparedStatement(IDBManager iDBManager) throws Throwable {
        String string = "update " + iDBManager.keyWordEscape(this.metaData.getTableName()) + " set ";
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isModify()) continue;
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + " =?,";
        }
        string = string.substring(0, string.length() - 1) + " where ";
        for (Column column : this.metaData.getColumnList()) {
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + " = ? and ";
        }
        string = string.substring(0, string.length() - 4);
        return new PsPara(iDBManager.preparedUpdateStatement(string), string);
    }

    @Override
    public PsPara createInsertPreparedStatement(IDBManager iDBManager) throws Throwable {
        String string = "insert into " + iDBManager.keyWordEscape(this.metaData.getTableName()) + " (";
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isInsert()) continue;
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + ",";
        }
        string = string.substring(0, string.length() - 1) + ") VALUES (";
        Iterator<Column> iterator = this.metaData.getColumnList().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isInsert()) continue;
            string = string + "?,";
        }
        string = string.substring(0, string.length() - 1) + ")";
        return new PsPara(iDBManager.preparedUpdateStatement(string), string);
    }

    protected String getMethodName(String string, String string2) {
        String string3 = string;
        string = string3.replaceFirst(string3.substring(0, 1), string.substring(0, 1).toUpperCase());
        return string2 + string;
    }

    @Override
    public QueryArguments getDeletePSArgs(IDBManager object, T t) throws Throwable {
        object = new ArrayList<Object>();
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isPrimaryKey()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object2 = t.getClass().getMethod(string, new Class[0]).invoke(t, new Object[0]);
            object.add(object2);
        }
        return new NormalQueryArguments(object);
    }

    @Override
    public QueryArguments getUpdatePSArgs(IDBManager object, T t) throws Throwable {
        object = new ArrayList<Object>();
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isModify()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object2 = t.getClass().getMethod(string, new Class[0]).invoke(t, new Object[0]);
            object.add(object2);
        }
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isPrimaryKey()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object3 = t.getClass().getMethod(string, new Class[0]).invoke(t, new Object[0]);
            object.add(object3);
        }
        return new NormalQueryArguments(object);
    }

    @Override
    public QueryArguments getInsertPSArgs(T t) throws Throwable {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isInsert()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object = t.getClass().getMethod(string, new Class[0]).invoke(t, new Object[0]);
            arrayList.add(object);
        }
        return new NormalQueryArguments(arrayList);
    }

    @Override
    public T loadRow(ResultSet resultSet) throws Throwable {
        return null;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
    }

    @Override
    public Spliterator<T> spliterator() {
        return null;
    }

    @Override
    public QueryArguments getLoadPSArgs(IDBManager iDBManager) {
        return null;
    }
}

