/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.specificCache;

import com.bokesoft.yes.mid.cache.CacheDBTable;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.specificCache.Column;
import com.bokesoft.yes.mid.specificCache.MetaData;
import com.bokesoft.yes.mid.specificCache.SpecificRow;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;

public class CacheTableWithRowImplement<T extends SpecificRow>
extends CacheDBTable<T> {
    private MetaData metaData = new MetaData();
    private Class<T> rowClass;
    private Method[] methods;

    public CacheTableWithRowImplement(Class<T> clazz) {
        this.rowClass = clazz;
        this.methods = clazz.getMethods();
    }

    public void load(IDBManager object, String object2) throws Throwable {
        block6: {
            this.rowList.clear();
            this.rowMap.clear();
            object = object.preparedQueryStatement((String)object2);
            object2 = null;
            try {
                object2 = object.executeQuery();
                while (object2.next()) {
                    SpecificRow specificRow = (SpecificRow)((Object)this.rowClass.newInstance());
                    this.loadRow(specificRow, (ResultSet)object2);
                    specificRow.setNormalAfterLoad();
                    this.internalAddRow(specificRow);
                }
                if (object2 == null) break block6;
            }
            catch (Throwable throwable) {
                if (object2 != null) {
                    object2.close();
                }
                if (object != null) {
                    object.close();
                }
                throw throwable;
            }
            object2.close();
        }
        if (object != null) {
            object.close();
            return;
        }
    }

    protected void loadRow(T t, ResultSet resultSet) throws Throwable {
        int n = 1;
        for (Column column : this.metaData.getColumnList()) {
            if (column.isLoad()) {
                String string = this.getMethodName(column.getColumnName(), "set");
                this.getMethod(string).invoke(t, resultSet.getObject(n));
            }
            ++n;
        }
    }

    @Override
    public PsPara getLoadPreparedStatement(IDBManager iDBManager) throws Throwable {
        return null;
    }

    @Override
    public PsPara createDeletePreparedStatement(IDBManager iDBManager) throws Throwable {
        String string = "delete from " + iDBManager.keyWordEscape(this.metaData.getTableName()) + " where ";
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isPrimaryKey()) continue;
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + " = ? and ";
        }
        string = string.substring(0, string.length() - 4);
        return new PsPara(iDBManager.preparedUpdateStatement(string), string);
    }

    @Override
    public PsPara createUpdatePreparedStatement(IDBManager iDBManager) throws Throwable {
        String string = "update " + iDBManager.keyWordEscape(this.metaData.getTableName()) + " set ";
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isModify()) continue;
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + " =?,";
        }
        string = string.substring(0, string.length() - 1) + " where ";
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isPrimaryKey()) continue;
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + " = ? and ";
        }
        string = string.substring(0, string.length() - 4);
        return new PsPara(iDBManager.preparedUpdateStatement(string), string);
    }

    @Override
    public PsPara createInsertPreparedStatement(IDBManager iDBManager) throws Throwable {
        String string = "insert into " + iDBManager.keyWordEscape(this.metaData.getTableName()) + " (";
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isInsert()) continue;
            string = string + iDBManager.keyWordEscape(column.getColumnName()) + ",";
        }
        string = string.substring(0, string.length() - 1) + ") VALUES (";
        Iterator<Column> iterator = this.metaData.getColumnList().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isInsert()) continue;
            string = string + "?,";
        }
        string = string.substring(0, string.length() - 1) + ")";
        return new PsPara(iDBManager.preparedUpdateStatement(string), string);
    }

    protected String getMethodName(String string, String string2) {
        String string3 = string;
        string = string3.replaceFirst(string3.substring(0, 1), string.substring(0, 1).toUpperCase());
        return string2 + string;
    }

    protected Method getMethod(String string) {
        Method[] methodArray = this.methods;
        int n = this.methods.length;
        for (int k = 0; k < n; ++k) {
            Method method = methodArray[k];
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    @Override
    public QueryArguments getDeletePSArgs(IDBManager object, T t) throws Throwable {
        object = new ArrayList<Object>();
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isPrimaryKey()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object2 = this.getMethod(string).invoke(t, new Object[0]);
            object.add(object2);
        }
        return new NormalQueryArguments(object);
    }

    @Override
    public QueryArguments getUpdatePSArgs(IDBManager object, T t) throws Throwable {
        object = new ArrayList<Object>();
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isModify()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object2 = this.getMethod(string).invoke(t, new Object[0]);
            object.add(object2);
        }
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isPrimaryKey()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object3 = this.getMethod(string).invoke(t, new Object[0]);
            object.add(object3);
        }
        return new NormalQueryArguments(object);
    }

    @Override
    public QueryArguments getInsertPSArgs(T t) throws Throwable {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Column column : this.metaData.getColumnList()) {
            if (!column.isInsert()) continue;
            String string = this.getMethodName(column.getColumnName(), "get");
            Object object = this.getMethod(string).invoke(t, new Object[0]);
            arrayList.add(object);
        }
        return new NormalQueryArguments(arrayList);
    }

    @Override
    public T loadRow(ResultSet resultSet) throws Throwable {
        return null;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public QueryArguments getLoadPSArgs(IDBManager iDBManager) {
        return null;
    }
}

