/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.session;

import com.bokesoft.yes.mid.session.AccountLockoutInfo;
import com.bokesoft.yes.mid.session.IAccountLockoutInfo;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yes.mid.session.SysSessionLog;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AccountLockoutInfoMap
implements IAccountLockoutInfoMap {
    private ICache<IAccountLockoutInfo> accountLockMap = CacheFactory.getInstance().createCache("AccountLockoutCache");
    private int lockThreshold = 0;
    private int lockDuration = 0;
    public static final String ACCOUNT_LOCKOUT_CACHE = "AccountLockoutCache";

    public void put(String string, IAccountLockoutInfo iAccountLockoutInfo) {
        this.accountLockMap.put(string, (Object)iAccountLockoutInfo);
    }

    @Override
    public IAccountLockoutInfo get(String string) {
        return (IAccountLockoutInfo)this.accountLockMap.get(string);
    }

    @Override
    public void setAccountLockoutThreshold(int n) {
        this.lockThreshold = n;
    }

    @Override
    public void setAccountLockoutDuration(int n) {
        this.lockDuration = n;
    }

    @Override
    public void check(DefaultContext defaultContext, ISessionInfo iSessionInfo) throws SessionException {
        if (this.lockThreshold > 0) {
            long l = iSessionInfo.getOperatorID();
            int n = iSessionInfo.getMode();
            IAccountLockoutInfo iAccountLockoutInfo = (IAccountLockoutInfo)this.accountLockMap.get(l + "_" + n);
            if (iAccountLockoutInfo != null && iAccountLockoutInfo.getLogin_failed_count() >= this.lockThreshold) {
                if (this.lockDuration > 0) {
                    long l2;
                    long l3;
                    long l4 = new Date().getTime();
                    if (l4 - (l3 = iAccountLockoutInfo.getLockDate().getTime()) >= (l2 = (long)(this.lockDuration * 1000))) {
                        this.unlock(l, n);
                        new SysSessionLog().logUnlock(defaultContext, l, n);
                        return;
                    }
                    throw new SessionException(4, SessionException.formatMessage(null, 4, new Object[0]));
                }
                throw new SessionException(4, SessionException.formatMessage(null, 4, new Object[0]));
            }
        }
    }

    @Override
    public void log(DefaultContext defaultContext, long l, int n, int n2) throws SessionException {
        if (this.lockThreshold > 0) {
            switch (n2) {
                case 1: {
                    String string = l + "_" + n;
                    IAccountLockoutInfo iAccountLockoutInfo = (IAccountLockoutInfo)this.accountLockMap.get(string);
                    if (iAccountLockoutInfo == null) {
                        iAccountLockoutInfo = new AccountLockoutInfo();
                    }
                    iAccountLockoutInfo.recordLoginFailed();
                    this.accountLockMap.put(string, (Object)iAccountLockoutInfo);
                    if (iAccountLockoutInfo.getLogin_failed_count() != this.lockThreshold) break;
                    new SysSessionLog().logLock(defaultContext, l, n);
                    throw new SessionException(14, SessionException.formatMessage((ILocale)defaultContext.getEnv(), 14, this.lockThreshold));
                }
                case 0: {
                    this.accountLockMap.remove(l + "_" + n);
                }
            }
        }
    }

    @Override
    public boolean unlock(long l, int n) {
        String string = l + "_" + n;
        if (this.accountLockMap.contains(string)) {
            this.accountLockMap.remove(string);
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getKeys() {
        return this.accountLockMap.getKeys();
    }

    @Override
    public Map<String, IAccountLockoutInfo> updateAccountLockMap() {
        HashMap<String, IAccountLockoutInfo> hashMap = new HashMap<String, IAccountLockoutInfo>();
        Object object = this.accountLockMap.getKeys();
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object = (IAccountLockoutInfo)this.accountLockMap.get(string);
                if (object == null || object.getLogin_failed_count() < this.lockThreshold) continue;
                if (this.lockDuration > 0) {
                    long l;
                    long l2;
                    long l3 = new Date().getTime();
                    if (l3 - (l2 = object.getLockDate().getTime()) >= (l = (long)(this.lockDuration * 1000))) {
                        this.accountLockMap.remove(string);
                        continue;
                    }
                    hashMap.put(string, (IAccountLockoutInfo)object);
                    continue;
                }
                hashMap.put(string, (IAccountLockoutInfo)object);
            }
        }
        return hashMap;
    }
}

