/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.schemamgr;

import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCheck;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreate;
import com.bokesoft.yigo.mid.schemamgr.SchemaCheckFactory;
import com.bokesoft.yigo.mid.schemamgr.SchemaCreateFactory;
import java.util.List;

public class SchemaProcess {
    DataBaseInfo info = null;
    private ISchemaCreate creator = null;
    private ISchemaCheck checker = null;

    public SchemaProcess() {
    }

    public SchemaProcess(IDBManager iDBManager) throws Throwable {
        this.info = new DataBaseInfo();
        iDBManager.initDataBaseInfo(this.info);
    }

    private ISchemaCreate getCreate() throws Throwable {
        if (this.creator == null) {
            this.creator = SchemaCreateFactory.getInstance().create();
        }
        return this.creator;
    }

    private ISchemaCheck getCheck() throws Throwable {
        if (this.checker == null) {
            this.checker = SchemaCheckFactory.getInstance().create();
        }
        return this.checker;
    }

    public void tableRebuild(IDBManager iDBManager, MetaSchemaTable metaSchemaTable) throws Throwable {
        if (!this.getCheck().checkTableExist(iDBManager, metaSchemaTable.getKey())) {
            this.getCreate().createTable(iDBManager, metaSchemaTable);
            Object object = metaSchemaTable.getIndexCollection();
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    MetaIndex metaIndex = (MetaIndex)object.next();
                    this.getCreate().createIndex(iDBManager, metaSchemaTable, metaIndex);
                }
            }
        } else {
            MetaIndex metaIndex2 = this.getCheck().checkTable(iDBManager, metaSchemaTable);
            if (metaIndex2.size() != 0) {
                this.getCreate().alterTable(iDBManager, metaSchemaTable, (List<MetaSchemaColumn>)metaIndex2);
            }
            if ((metaIndex2 = this.getCheck().checkIndex(iDBManager, metaSchemaTable)) != null && metaIndex2.size() != 0) {
                for (MetaIndex metaIndex2 : metaIndex2) {
                    this.getCreate().createIndex(iDBManager, metaSchemaTable, metaIndex2);
                }
            }
        }
        if (this.info != null) {
            this.info.updateInfo(metaSchemaTable);
        }
    }

    public void tableRepartition(IDBManager iDBManager, MetaSchemaTable metaSchemaTable) throws Throwable {
        if (!this.getCheck().checkPartition(iDBManager, metaSchemaTable, this.info)) {
            this.getCreate().alterPartition(iDBManager, metaSchemaTable);
            if (this.info != null) {
                this.info.updatePartitionInfo(metaSchemaTable);
            }
            return;
        }
    }
}

