/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.rights;

import com.bokesoft.yes.mid.rights.IRightsProvider;
import com.bokesoft.yes.mid.rights.IRightsProxy;
import com.bokesoft.yes.mid.rights.MidRightsProxyFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.rights.BaseFormRights;
import com.bokesoft.yigo.struct.rights.CustomRights;
import com.bokesoft.yigo.struct.rights.DictRights;
import com.bokesoft.yigo.struct.rights.EntryRights;
import com.bokesoft.yigo.struct.rights.FormRights;
import com.bokesoft.yigo.struct.rights.ServiceRights;
import java.util.List;

public class MidUserRights
implements IRightsProvider {
    private IRightsProxy operatorProxy = null;
    private IRightsProxy roleProxy = null;
    private long operatorID = -1L;
    private List<Long> roleIDList = null;

    public MidUserRights(DefaultContext defaultContext) {
        this.operatorID = defaultContext.getVE().getEnv().getUserID();
        this.roleIDList = defaultContext.getVE().getEnv().getRoleIDList();
        this.operatorProxy = MidRightsProxyFactory.getInstance().createOperatorRightsProxy(defaultContext);
        this.roleProxy = MidRightsProxyFactory.getInstance().createRoleRightsProxy(defaultContext);
    }

    @Override
    public DictRights getDictRights(String string) throws Throwable {
        DictRights dictRights = new DictRights(string);
        DictRights dictRights2 = this.operatorProxy.loadDictRights(this.operatorID, string);
        dictRights.merge(dictRights2);
        if (this.roleIDList != null && !this.roleIDList.isEmpty()) {
            for (long l : this.roleIDList) {
                dictRights2 = this.roleProxy.loadDictRights(l, string);
                dictRights.merge(dictRights2);
            }
        }
        return dictRights;
    }

    @Override
    public EntryRights getEntryRights() throws Throwable {
        EntryRights entryRights = new EntryRights();
        EntryRights entryRights2 = this.operatorProxy.loadEntryRights(this.operatorID);
        entryRights.merge(entryRights2);
        if (this.roleIDList != null && !this.roleIDList.isEmpty()) {
            for (long l : this.roleIDList) {
                entryRights2 = this.roleProxy.loadEntryRights(l);
                entryRights.merge(entryRights2);
            }
        }
        return entryRights;
    }

    @Override
    public FormRights getFormRights(String string) throws Throwable {
        FormRights formRights = new FormRights(string);
        FormRights formRights2 = this.operatorProxy.loadFormRights(this.operatorID, string);
        formRights.merge((BaseFormRights)formRights2);
        if (this.roleIDList != null && !this.roleIDList.isEmpty()) {
            for (long l : this.roleIDList) {
                formRights2 = this.roleProxy.loadFormRights(l, string);
                formRights.merge((BaseFormRights)formRights2);
            }
        }
        return formRights;
    }

    @Override
    public CustomRights getCustomRights() throws Throwable {
        CustomRights customRights = new CustomRights();
        CustomRights customRights2 = this.operatorProxy.loadCustomRights(this.operatorID);
        customRights.merge(customRights2);
        if (this.roleIDList != null && !this.roleIDList.isEmpty()) {
            for (long l : this.roleIDList) {
                customRights2 = this.roleProxy.loadCustomRights(l);
                customRights.merge(customRights2);
            }
        }
        return customRights;
    }

    @Override
    public ServiceRights getServiceRights() throws Throwable {
        ServiceRights serviceRights = new ServiceRights();
        ServiceRights serviceRights2 = this.operatorProxy.loadServiceRights(this.operatorID);
        serviceRights.merge(serviceRights2);
        if (this.roleIDList != null && !this.roleIDList.isEmpty()) {
            for (long l : this.roleIDList) {
                serviceRights2 = this.roleProxy.loadServiceRights(l);
                serviceRights.merge(serviceRights2);
            }
        }
        return serviceRights;
    }
}

