/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.redis;

import com.bokesoft.yes.common.util.SerializeUtil;
import com.bokesoft.yigo.mid.nosql.Connection;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisSimpleConnection
implements Connection {
    private JedisPool pool;
    private int dbIndex;
    private String prefix;

    public RedisSimpleConnection(JedisPool jedisPool, int n, String string) {
        this.pool = jedisPool;
        this.dbIndex = n;
        this.prefix = string;
    }

    public Jedis getJedis() {
        Jedis jedis = null;
        if (this.pool != null) {
            jedis = this.pool.getResource();
        }
        if (this.dbIndex != 0) {
            jedis.select(this.dbIndex);
        }
        return jedis;
    }

    public void destroy() {
        if (this.pool != null) {
            this.pool.destroy();
        }
    }

    private String realKey(String string) {
        String string2 = string;
        if (this.prefix != null && !this.prefix.isEmpty()) {
            string2 = this.prefix + string;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(String string, String string2, Object object) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            object = SerializeUtil.serialize((Object)object);
            object = Base64.getEncoder().encodeToString((byte[])object);
            jedis.hset(this.realKey(string), string2, (String)object);
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }

    @Override
    public Object getValue(String object, String string) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            object = jedis.hget(this.realKey((String)object), string);
            if (object == null || ((String)object).isEmpty()) {
                return null;
            }
            object = SerializeUtil.unSerialize((byte[])Base64.getDecoder().decode((String)object));
            return object;
        }
    }

    @Override
    public boolean contains(String string, String string2) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            boolean bl = jedis.hexists(this.realKey(string), string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void remove(String string, String string2) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.hdel(this.realKey(string), new String[]{string2});
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }

    @Override
    public long size(String string) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            long l = jedis.hlen(this.realKey(string));
            return l;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeAll(String string, List<String> iterator) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            string = this.realKey(string);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                this.remove(string, string2);
            }
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }

    @Override
    public Set<String> getKeys(String object) {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            object = jedis.hkeys(this.realKey((String)object));
            return object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void clear(String string) {
        Jedis jedis = null;
        try {
            jedis = this.getJedis();
            jedis.del(string);
            if (jedis == null) return;
        }
        catch (Throwable throwable) {
            if (jedis == null) throw throwable;
            jedis.close();
            throw throwable;
        }
        jedis.close();
    }
}

