/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.redis;

import com.bokesoft.yes.common.util.SerializeUtil;
import com.bokesoft.yigo.mid.nosql.Connection;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.JedisCluster;

public class RedisClusterConnection
implements Connection {
    private JedisCluster cluster;
    private String prefix;

    public RedisClusterConnection(JedisCluster jedisCluster, String string) {
        this.cluster = jedisCluster;
        this.prefix = string;
    }

    private String realKey(String string) {
        String string2 = string;
        if (this.prefix != null && !this.prefix.isEmpty()) {
            string2 = this.prefix + string;
        }
        return string2;
    }

    @Override
    public void setValue(String string, String string2, Object object) {
        object = SerializeUtil.serialize((Object)object);
        object = Base64.getEncoder().encodeToString((byte[])object);
        this.cluster.hset(this.realKey(string), string2, (String)object);
    }

    @Override
    public Object getValue(String string, String string2) {
        if ((string = this.cluster.hget(this.realKey(string), string2)) == null || string.isEmpty()) {
            return null;
        }
        return SerializeUtil.unSerialize((byte[])Base64.getDecoder().decode(string));
    }

    @Override
    public boolean contains(String string, String string2) {
        return this.cluster.hexists(this.realKey(string), string2);
    }

    @Override
    public long size(String string) {
        return this.cluster.hlen(this.realKey(string));
    }

    @Override
    public void remove(String string, String string2) {
        this.cluster.hdel(this.realKey(string), new String[]{string2});
    }

    @Override
    public void removeAll(String string, List<String> object) {
        string = this.realKey(string);
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            this.remove(string, string2);
        }
    }

    @Override
    public Set<String> getKeys(String string) {
        return this.cluster.hkeys(this.realKey(string));
    }

    @Override
    public void clear(String string) {
        this.cluster.del(string);
    }
}

