/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dict;

import com.bokesoft.yes.struct.dict.ItemTableMetaDatas;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.struct.dict.Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SyncDictItemCache
implements com.bokesoft.yes.tools.dic.item.ICache {
    private ICache<Long> versions = null;
    private Map<Long, Long> curVersions = new HashMap<Long, Long>();
    private Map<Long, Item> items = new ConcurrentHashMap<Long, Item>();
    private String[] sortColumns = null;
    private Item rootItem = null;

    public SyncDictItemCache(ItemTableMetaDatas object) {
        String string = object.getItemKey();
        this.versions = CacheFactory.getInstance().createCache(string);
        this.rootItem = new Item(object.getItemKey(), 0L);
        object = object.getMainTable().getSortColumns();
        this.sortColumns = ((String)object).split(",");
    }

    public Item getItemByID(long l) throws Throwable {
        if (!this.checkVersion(l)) {
            return null;
        }
        if (l == 0L) {
            return this.rootItem;
        }
        return this.items.get(l);
    }

    public List<Item> getItems(List<Long> object) throws Throwable {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        object = object.iterator();
        while (object.hasNext()) {
            long l = (Long)object.next();
            Item item = this.getItemByID(l);
            if (item == null) continue;
            arrayList.add(item);
        }
        return arrayList;
    }

    public void addItem(Item item) throws Throwable {
        if (item != null) {
            this.items.put(item.getID(), item);
        }
    }

    public void addItems(List<Item> list) throws Throwable {
        if (list != null && list.size() > 0) {
            for (int k = 0; k < list.size(); ++k) {
                Item item = list.get(k);
                this.items.put(item.getID(), item);
            }
        }
    }

    public void reomveItem(long l) throws Throwable {
        this.items.remove(l);
    }

    public boolean existItem(long l) throws Throwable {
        if (!this.checkVersion(l)) {
            return false;
        }
        return this.items.containsKey(l);
    }

    public Item locate(String string, Object object) throws Throwable {
        return null;
    }

    public String[] getSortColumns(String string) {
        return this.sortColumns;
    }

    public int getLayerLevel(String string) {
        return 0;
    }

    public void clear() {
        this.items.clear();
    }

    public long update(Long l) {
        try {
            Long l2 = this.curVersions.get(l);
            Long l3 = (Long)this.versions.get(l.toString());
            if (l2 == null) {
                l2 = 0L;
            }
            if (l3 == null) {
                l3 = 0L;
            }
            long l4 = Math.max(l2, l3) + 1L;
            this.curVersions.put(l, l4);
            this.versions.put(l.toString(), (Object)l4);
            long l5 = l4;
            return l5;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.curVersions.remove(l);
            this.items.remove(l);
            return -1L;
        }
        finally {
            this.items.remove(l);
        }
    }

    private boolean checkVersion(Long l) {
        Long l2 = this.curVersions.get(l);
        Long l3 = (Long)this.versions.get(l.toString());
        if (l2 == null) {
            l2 = 0L;
        }
        if (l3 == null) {
            l3 = 0L;
        }
        boolean bl = true;
        if (l3 < l2) {
            bl = true;
        } else if (l3 == l2) {
            bl = true;
        } else if (l3 > l2) {
            bl = false;
            this.items.remove(l);
            this.curVersions.put(l, l3);
        }
        return bl;
    }
}

