/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.preparesql;

import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.util.ArrayList;

public class QuerySQLParameters {
    private ArrayList<String> resultFieldKeyList = new ArrayList();
    private String tableName;
    private ArrayList<String> conditionFieldKeyList = new ArrayList();
    private ArrayList<Object> conditionFieldValueList = new ArrayList();
    private ArrayList<String> conditionSignList = new ArrayList();
    private ArrayList<String> sortList = null;
    private ArrayList<Boolean> sortTypeList = null;

    public void addResultFieldKey(String string) {
        this.resultFieldKeyList.add(string);
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void putCondition(String string, Object object) {
        this.putCondition(string, object, "=");
    }

    public void putCondition(int n, String string, Object object) {
        this.putCondition(n, string, object, "=");
    }

    public void putCondition(String string, Object object, String string2) {
        this.conditionFieldKeyList.add(string);
        this.conditionFieldValueList.add(object);
        this.conditionSignList.add(string2);
    }

    public void putSortColumn(String string, Boolean bl) {
        if (this.sortList == null) {
            this.sortList = new ArrayList();
            this.sortTypeList = new ArrayList();
        }
        this.sortList.add(string);
        this.sortTypeList.add(bl);
    }

    public void putCondition(int n, String string, Object object, String string2) {
        this.conditionFieldKeyList.add(n, string);
        this.conditionFieldValueList.add(n, object);
        this.conditionSignList.add(n, string2);
    }

    public String createSQL(IDBManager iDBManager) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder("select ");
        if (this.resultFieldKeyList == null || this.resultFieldKeyList.size() == 0) {
            throw new MidCoreException(5, "\u67e5\u8be2\u8bed\u53e5\u672a\u6307\u660e\u67e5\u8be2\u5217");
        }
        for (String string : this.resultFieldKeyList) {
            stringBuilder.append(iDBManager.keyWordEscape(string));
            stringBuilder.append(",");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
        stringBuilder.append(" from ");
        stringBuilder.append(iDBManager.keyWordEscape(this.tableName));
        if (this.conditionFieldKeyList != null && this.conditionFieldKeyList.size() > 0) {
            stringBuilder.append(" where ");
            int n = this.conditionFieldKeyList.size();
            for (int k = 0; k < n; ++k) {
                String string = this.conditionFieldKeyList.get(k);
                stringBuilder.append(iDBManager.keyWordEscape(string));
                stringBuilder.append(" " + this.conditionSignList.get(k) + " ? and ");
            }
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.delete(stringBuilder3.length() - 4, stringBuilder.length());
        }
        stringBuilder.append(" ");
        return stringBuilder.toString();
    }

    public String getSortStr(IDBManager iDBManager) throws Throwable {
        StringBuilder stringBuilder = new StringBuilder(" ");
        int n = this.sortList.size();
        for (int k = 0; k < n; ++k) {
            String string = this.sortList.get(k);
            stringBuilder.append(iDBManager.keyWordEscape(string));
            if (!this.sortTypeList.get(k).booleanValue()) {
                stringBuilder.append(" DESC");
            }
            stringBuilder.append(",");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.delete(stringBuilder2.length() - 1, stringBuilder.length());
        stringBuilder.append(" ");
        return stringBuilder.toString();
    }

    public boolean existSort() {
        return this.sortList != null;
    }

    public ArrayList<String> getResultFieldKeyList() {
        return this.resultFieldKeyList;
    }

    public ArrayList<Object> getConditionFieldValueList() {
        return this.conditionFieldValueList;
    }
}

