/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.tools.document;

import com.bokesoft.yes.common.struct.MultiKey;
import com.bokesoft.yes.common.struct.MultiKeyNode;
import com.bokesoft.yes.common.struct.report.MultiDimNode;
import com.bokesoft.yes.common.struct.report.MultiDimValue;
import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataTableUtil {
    public static Map<MetaTable, DataTableMetaData> cacheMetaDataMap = new HashMap<MetaTable, DataTableMetaData>();

    public static DataTable newEmptyDataTable(MetaTable metaTable) {
        if (metaTable == null) {
            throw new RuntimeException("MetaTable\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DataTableMetaData dataTableMetaData = cacheMetaDataMap.get(metaTable);
        boolean isDiff = DataTableUtil.checkMetaTableColumnInfo(metaTable, dataTableMetaData);
        if (!isDiff) {
            DataTable dataTable = new DataTable(dataTableMetaData);
            dataTable.setKey(metaTable.getKey());
            dataTable.setCheckLength(metaTable.isPersist().booleanValue());
            return dataTable;
        }
        cacheMetaDataMap.remove(metaTable);
        dataTableMetaData = null;
        DataTable table = new DataTable();
        table.setKey(metaTable.getKey());
        table.setCheckLength(metaTable.isPersist().booleanValue());
        Iterator it = metaTable.iterator();
        MetaColumn metaColumn = null;
        int index = 0;
        while (it.hasNext()) {
            metaColumn = (MetaColumn)it.next();
            if (metaColumn.isHidden().booleanValue() || metaColumn.isSupportI18n().booleanValue()) continue;
            String columnKey = metaColumn.getKey();
            ColumnInfo columnInfo = new ColumnInfo(columnKey, metaColumn.getDataType().intValue());
            columnInfo.setAccessControl(metaColumn.isAccessControl());
            columnInfo.setPrimary(metaColumn.getIsPrimary());
            columnInfo.setDefaultValue(metaColumn.getDefaultValue());
            columnInfo.setScale(metaColumn.getScale());
            columnInfo.setLength(metaColumn.getLength());
            columnInfo.setCodeColumnKey(metaColumn.getCodeColumnKey());
            columnInfo.setCheckLength(metaColumn.isPersist().booleanValue());
            if (metaColumn.isIgnoreQuery().booleanValue()) {
                table.addColumn(columnInfo);
                continue;
            }
            table.addColumn(index, columnInfo);
            ++index;
        }
        cacheMetaDataMap.put(metaTable, table.getMetaData());
        return table;
    }

    private static boolean checkMetaTableColumnInfo(MetaTable metaTable, DataTableMetaData dataTableMetaData) {
        if (dataTableMetaData == null) {
            return true;
        }
        if (metaTable.size() != dataTableMetaData.getColumnCount()) {
            return true;
        }
        for (MetaColumn column : metaTable) {
            String columnKey = column.getKey();
            int columnIndex = dataTableMetaData.findColumnIndexByKey(columnKey);
            if (columnIndex >= 0) continue;
            return true;
        }
        return false;
    }

    public static void getIndexesAndTypes(DataTable table, List<String> columnKeys, int[] indexes, int[] types) throws Throwable {
        DataTableMetaData tableMetaData = table.getMetaData();
        for (int i = 0; i < columnKeys.size(); ++i) {
            ColumnInfo columnInfo = tableMetaData.getColumnInfo(columnKeys.get(i));
            indexes[i] = tableMetaData.findColumnIndexByKey(columnInfo.getColumnKey());
            types[i] = columnInfo.getUserDataType();
        }
    }

    public static int locate(DataTable table, MultiDimValue dimValue) {
        MultiDimNode node = null;
        MultiDimValue other = null;
        table.beforeFirst();
        while (table.next()) {
            other = new MultiDimValue();
            int size = dimValue.size();
            for (int i = 0; i < size; ++i) {
                node = dimValue.getValue(i);
                other.addValue(DataTableUtil.makeDimNode(table, node.getColumnKey()));
            }
            if (!dimValue.equals((Object)other)) continue;
            return table.getBookmark();
        }
        return -1;
    }

    public static MultiDimValue makeDimValue(DataTable table, List<String> columnKeys) {
        MultiDimValue dimValue = new MultiDimValue();
        for (String columnKey : columnKeys) {
            dimValue.addValue(DataTableUtil.makeDimNode(table, columnKey));
        }
        return dimValue;
    }

    private static MultiDimNode makeDimNode(DataTable table, String columnKey) {
        ColumnInfo info = table.getMetaData().getColumnInfo(columnKey);
        Object value = table.getObject(columnKey);
        MultiDimNode node = new MultiDimNode(columnKey, info.getDataType(), value);
        return node;
    }

    public static MultiKey makeMultiKey(DataTable table, int[] indexes, int[] types) {
        MultiKey value = new MultiKey();
        int length = indexes.length;
        for (int i = 0; i < length; ++i) {
            value.addValue(new MultiKeyNode(types[i], table.getObject(indexes[i])));
        }
        return value;
    }

    public static MultiKey convertDimValue(MultiDimValue dimValue) {
        MultiKey key = new MultiKey();
        int size = dimValue.size();
        for (int i = 0; i < size; ++i) {
            MultiDimNode dimNode = dimValue.getValue(i);
            MultiKeyNode node = new MultiKeyNode(DBTypeUtil.dataType2JavaDataType((int)dimNode.getDataType()), dimNode.getValue());
            key.addValue(node);
        }
        return key;
    }

    public static void append(DataTable src, DataTable tgt, MetaTable metaTable) throws Throwable {
        DataTableUtil.append(src, tgt, metaTable, -1);
    }

    public static void append(DataTable src, DataTable tgt, MetaTable metaTable, int parentBkmk) throws Throwable {
        DataTableMetaData srcMetaData = src.getMetaData();
        DataTableMetaData tgtMetaData = tgt.getMetaData();
        int colIndex = -1;
        ColumnInfo tgtCoInfo = null;
        Iterator it = null;
        String key = null;
        src.beforeFirst();
        while (src.next()) {
            DocumentUtil.newRow(metaTable, tgt);
            for (MetaColumn metaColumn : metaTable) {
                if (metaColumn.isSupportI18n().booleanValue()) continue;
                key = metaColumn.getKey();
                colIndex = srcMetaData.findColumnIndexByKey(key);
                tgtCoInfo = tgtMetaData.getColumnInfo(key);
                if (tgtCoInfo == null || colIndex < 0) continue;
                tgt.setObject(key, TypeConvertor.toDataType((int)tgtCoInfo.getDataType(), (Object)src.getObject(key)));
            }
            if (parentBkmk == -1) continue;
            tgt.setParentBookmark(parentBkmk);
        }
    }

    public static void appendAll(DataTable src, DataTable tgt) {
        src.beforeFirst();
        int count = src.getMetaData().getColumnCount();
        while (src.next()) {
            tgt.append();
            tgt.setState(tgt.getState());
            for (int i = 0; i < count; ++i) {
                tgt.setObject(i, src.getObject(i));
            }
        }
    }

    public static DataTable join(DataTable table1, DataTable table2, String[] selectColumnKeys, String[][] conditionColumnKeys) {
        int driverTableIndex;
        int indexTableIndex;
        if (table2.size() >= table1.size()) {
            indexTableIndex = 1;
            driverTableIndex = 0;
        } else {
            indexTableIndex = 0;
            driverTableIndex = 1;
        }
        return DataTableUtil.baseJoin(table1, table2, selectColumnKeys, conditionColumnKeys, indexTableIndex, driverTableIndex, false);
    }

    public static DataTable leftJoin(DataTable table1, DataTable table2, String[] selectColumnKeys, String[][] conditionColumnKeys) {
        return DataTableUtil.baseJoin(table1, table2, selectColumnKeys, conditionColumnKeys, 1, 0, true);
    }

    public static DataTable rightJoin(DataTable table1, DataTable table2, String[] selectColumnKeys, String[][] conditionColumnKeys) {
        return DataTableUtil.baseJoin(table1, table2, selectColumnKeys, conditionColumnKeys, 0, 1, true);
    }

    private static DataTable baseJoin(DataTable table1, DataTable table2, String[] selectColumnKeys, String[][] conditionColumnKeys, int indexTableIndex, int driverTableIndex, boolean addDriverRowIfNotIndex) {
        List<Integer> list;
        ObjectArray value;
        if (conditionColumnKeys == null || conditionColumnKeys.length == 0) {
            throw new RuntimeException("\u67e5\u8be2\u5217\u540d\u4e0d\u53ef\u4e3a\u7a7a");
        }
        Object[] objectArray = DataTableUtil.mergeEmpty(table1, table2, selectColumnKeys);
        DataTable newTable = (DataTable)objectArray[0];
        int[][] indexArray = (int[][])objectArray[1];
        HashMap<ObjectArray, ArrayList<Integer>> indexMap = new HashMap<ObjectArray, ArrayList<Integer>>();
        DataTable indexTable = indexTableIndex == 0 ? table1 : table2;
        DataTable driverTable = driverTableIndex == 0 ? table1 : table2;
        indexTable.beforeFirst();
        while (indexTable.next()) {
            value = DataTableUtil.newObjectArray(indexTable, conditionColumnKeys, indexTableIndex);
            list = (ArrayList<Integer>)indexMap.get(value);
            if (list == null) {
                list = new ArrayList<Integer>();
                indexMap.put(value, (ArrayList<Integer>)list);
            }
            list.add(indexTable.getPos());
        }
        driverTable.beforeFirst();
        while (driverTable.next()) {
            value = DataTableUtil.newObjectArray(driverTable, conditionColumnKeys, driverTableIndex);
            list = (List)indexMap.get(value);
            if (list != null) {
                for (Integer pos : list) {
                    indexTable.setPos(pos.intValue());
                    newTable.append();
                    int size = indexArray.length;
                    for (int i = 0; i < size; ++i) {
                        int[] childArray = indexArray[i];
                        DataTable columnTable = childArray[0] == 0 ? table1 : table2;
                        int columnIndex = childArray[1];
                        newTable.setObject(i, columnTable.getObject(columnIndex));
                    }
                }
                continue;
            }
            if (!addDriverRowIfNotIndex) continue;
            newTable.append();
            int size = indexArray.length;
            for (int i = 0; i < size; ++i) {
                DataTable columnTable;
                int[] childArray = indexArray[i];
                DataTable dataTable = columnTable = childArray[0] == 0 ? table1 : table2;
                if (columnTable != driverTable) continue;
                int columnIndex = childArray[1];
                newTable.setObject(i, columnTable.getObject(columnIndex));
            }
        }
        return newTable;
    }

    private static ObjectArray newObjectArray(DataTable table, String[][] conditionColumnKeys, int conditionIndex) {
        Object[] valueArray = new Object[conditionColumnKeys.length];
        int size = valueArray.length;
        for (int i = 0; i < size; ++i) {
            valueArray[i] = table.getObject(conditionColumnKeys[i][conditionIndex]);
        }
        return new ObjectArray(valueArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object[] mergeEmpty(DataTable table1, DataTable table2, String[] selectColumnKeys) {
        int[][] indexArray;
        DataTable newTable = new DataTable();
        DataTableMetaData metaData1 = table1.getMetaData();
        DataTableMetaData metaData2 = table2.getMetaData();
        if (selectColumnKeys == null) {
            ColumnInfo columnInfo;
            int i;
            int columnCount1 = metaData1.getColumnCount();
            int columnCount2 = metaData2.getColumnCount();
            indexArray = new int[columnCount1 + columnCount2][2];
            for (i = 0; i < columnCount1; ++i) {
                columnInfo = metaData1.getColumnInfo(i);
                if (metaData2.constains(columnInfo.getColumnKey())) {
                    throw new RuntimeException("\u67e5\u8be2\u5217\u540d" + columnInfo.getColumnKey() + "\u5728\u4e24\u5f20\u8868\u4e2d\u540c\u65f6\u5b58\u5728");
                }
                newTable.addColumn(columnInfo.deepClone());
                indexArray[i] = new int[2];
                indexArray[i][0] = 0;
                indexArray[i][1] = i;
            }
            i = 0;
            while (i < columnCount2) {
                columnInfo = metaData2.getColumnInfo(i);
                newTable.addColumn(columnInfo.deepClone());
                int index = i + columnCount1;
                indexArray[index] = new int[2];
                indexArray[index][0] = 1;
                indexArray[index][1] = i++;
            }
            return new Object[]{newTable, indexArray};
        } else {
            boolean tableKeyEqual = Objects.equals(table1.getKey(), table2.getKey());
            indexArray = new int[selectColumnKeys.length][2];
            int size = selectColumnKeys.length;
            for (int i = 0; i < size; ++i) {
                int columnIndex;
                String columnKey = selectColumnKeys[i].trim();
                indexArray[i] = new int[2];
                ColumnInfo columnInfo = null;
                String[] columnKeyArray = columnKey.split(" +", 2);
                String aliasKey = null;
                String tableKey = null;
                if (columnKeyArray.length >= 2) {
                    columnKey = columnKeyArray[0];
                    aliasKey = columnKeyArray[1];
                }
                if ((columnKeyArray = columnKey.split("\\.", 2)).length >= 2) {
                    columnKey = columnKeyArray[1];
                    tableKey = columnKeyArray[0];
                }
                if (tableKey != null) {
                    if (tableKey.equals(table1.getKey())) {
                        if (tableKeyEqual && metaData2.constains(columnKey)) {
                            throw new RuntimeException("\u67e5\u8be2\u5217\u540d" + columnKey + "\u5728\u4e24\u5f20\u8868\u4e2d\u540c\u65f6\u5b58\u5728");
                        }
                        columnIndex = metaData1.findColumnIndexByKey(columnKey, true);
                        columnInfo = metaData1.getColumnInfo(columnIndex);
                        indexArray[i][0] = 0;
                        indexArray[i][1] = columnIndex;
                    } else {
                        if (!tableKey.equals(table2.getKey())) throw new RuntimeException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8868" + tableKey);
                        columnIndex = metaData2.findColumnIndexByKey(columnKey, true);
                        columnInfo = metaData2.getColumnInfo(columnIndex);
                        indexArray[i][0] = 1;
                        indexArray[i][1] = columnIndex;
                    }
                } else {
                    columnIndex = metaData1.findColumnIndexByKey(columnKey);
                    if (columnIndex >= 0) {
                        if (metaData2.constains(columnKey)) {
                            throw new RuntimeException("\u67e5\u8be2\u5217\u540d" + columnKey + "\u5728\u4e24\u5f20\u8868\u4e2d\u540c\u65f6\u5b58\u5728");
                        }
                        columnInfo = metaData1.getColumnInfo(columnIndex);
                        indexArray[i][0] = 0;
                    } else {
                        columnIndex = metaData2.findColumnIndexByKey(columnKey, true);
                        columnInfo = metaData2.getColumnInfo(columnIndex);
                        indexArray[i][0] = 1;
                    }
                    indexArray[i][1] = columnIndex;
                }
                columnInfo = columnInfo.deepClone();
                if (aliasKey != null) {
                    columnInfo.setColumnKey(aliasKey);
                }
                newTable.addColumn(columnInfo);
            }
        }
        return new Object[]{newTable, indexArray};
    }

    public static class ObjectArray {
        private final Object[] value;

        private ObjectArray(Object[] value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ObjectArray)) {
                return false;
            }
            return Arrays.deepEquals(this.value, ((ObjectArray)o).value);
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.value);
        }

        public String toString() {
            return Arrays.toString(this.value);
        }
    }
}

