/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.tools.dic.proxy;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.tools.dic.DictTools;
import com.bokesoft.yes.tools.dic.item.ICache;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yes.tools.dic.proxy.IDictServiceProxy;
import com.bokesoft.yes.tools.dic.proxy.ItemCacheManager;
import com.bokesoft.yes.tools.dic.proxy.ItemSortComparator;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.struct.dict.ItemData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.dict.IItemFilter;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DictCacheProxy
implements IDictCacheProxy {
    protected ItemCacheManager itemCaches = null;
    protected IDictServiceProxy service = null;
    protected VE ve = null;

    public DictCacheProxy(VE ve, IDictServiceProxy service) {
        this.ve = ve;
        this.service = service;
        this.itemCaches = new ItemCacheManager(ve);
    }

    @Override
    public Item getItem(String itemKey, long oid) throws Throwable {
        return this.getItem(itemKey, oid, 7);
    }

    @Override
    public Item getItem(String itemKey, long oid, int stateMask) throws Throwable {
        if (!this.hasRights(itemKey, oid)) {
            return null;
        }
        ICache cache = this.itemCaches.getItemCache(itemKey);
        Item item = cache.getItemByID(oid);
        if (item == null) {
            item = this.loadItems(cache, itemKey, oid);
        }
        if (item != null && DictTools.checkStateMask(stateMask, item.getEnable())) {
            return item;
        }
        return null;
    }

    @Override
    public List<Item> getItems(String itemKey, List<Long> oids) throws Throwable {
        ICache cache = this.itemCaches.getItemCache(itemKey);
        ArrayList<Long> notExists = new ArrayList<Long>();
        ArrayList<Item> items = new ArrayList();
        ArrayList<Long> hasRights = new ArrayList<Long>();
        for (long oid : oids) {
            if (!this.hasRights(itemKey, oid)) continue;
            if (!cache.existItem(oid)) {
                notExists.add(oid);
            }
            hasRights.add(oid);
        }
        if (notExists.size() > 0) {
            this.loadItems(cache, itemKey, notExists);
        }
        items = cache.getItems(hasRights);
        return items;
    }

    @Override
    public String getShowCaption(String itemKey, long oid) throws Throwable {
        if (oid == 0L) {
            return "";
        }
        Item item = this.getItem(itemKey, oid, 7);
        String sRet = "";
        if (item != null) {
            sRet = item.getCaption();
        }
        return sRet;
    }

    @Override
    public boolean existItem(String itemKey, long oid) throws Throwable {
        if (oid == 0L) {
            return true;
        }
        if (!this.hasRights(itemKey, oid)) {
            return false;
        }
        Item item = this.getItem(itemKey, oid, 7);
        return item != null;
    }

    @Override
    public void refreshItem(String itemKey, long oid) throws Throwable {
        ICache cache = this.itemCaches.getItemCache(itemKey);
        cache.removeItem(oid);
        this.loadItems(cache, itemKey, oid);
    }

    @Override
    public void refreshItems(String itemKey, List<Long> oids) throws Throwable {
        if (oids != null && oids.size() > 0) {
            ICache cache = this.itemCaches.getItemCache(itemKey);
            for (long oid : oids) {
                cache.removeItem(oid);
            }
            this.loadItems(cache, itemKey, oids);
        }
    }

    @Override
    public void removeItem(String itemKey, long oid) throws Throwable {
        this.itemCaches.getItemCache(itemKey).removeItem(oid);
    }

    @Override
    public List<ItemData> lookup(String itemKey, String fuzzyFields, String fuzzyValue, IItemFilter filter, ItemData root, int formState, int stateMask, int queryMatchType) throws Throwable {
        return this.lookup(itemKey, fuzzyFields, fuzzyValue, filter, root, formState, stateMask, 0, 0, queryMatchType, null, null);
    }

    @Override
    public List<ItemData> lookup(String itemKey, String fuzzyFields, String fuzzyValue, IItemFilter filter, ItemData root, int formState, int stateMask, int startRow, int maxRows, int queryMatchType, String formKey, String fieldKey) throws Throwable {
        List<ItemData> itemDatas = this.service.lookup(itemKey, fuzzyFields, fuzzyValue, filter, root, formState, stateMask, startRow, maxRows, queryMatchType, formKey, fieldKey);
        return itemDatas;
    }

    @Override
    public Item locate(String itemKey, String field, Object value, IItemFilter filter, ItemData root, int stateMask, int formState) throws Throwable {
        return this.locate(itemKey, field, value, filter, root, stateMask, null, null, formState);
    }

    @Override
    public Item locate(String itemKey, String field, Object value, IItemFilter filter, ItemData root, int stateMask, String formKey, String fieldKey, int formState) throws Throwable {
        ItemData itemData = this.service.locate(itemKey, field, value, filter, root, stateMask, formKey, fieldKey);
        if (itemData == null) {
            return null;
        }
        Item item = this.getItem(itemData.getItemKey(), itemData.getOID());
        return item;
    }

    @Override
    public Item locate2(String itemKey, String queryField, String fieldValue, IItemFilter filter, ItemData root, int stateMask, String formKey, String fieldKey, int formState) throws Throwable {
        ItemData itemData = this.service.locate2(itemKey, queryField, fieldValue, filter, root, stateMask, formKey, fieldKey);
        if (itemData == null) {
            return null;
        }
        Item item = this.getItem(itemData.getItemKey(), itemData.getOID());
        return item;
    }

    protected boolean hasRights(String itemKey, long oid) throws Throwable {
        return true;
    }

    @Override
    public List<Item> preLoadDictCache(MetaForm metaForm, Document document) throws Throwable {
        List<AbstractMetaObject> fields = this.getDictFields(metaForm);
        MetaDataBinding metaDataBinding = null;
        int controlType = 0;
        MetaDictProperties dictProperties = null;
        String tableKey = null;
        String columnKey = null;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        for (AbstractMetaObject metaObj : fields) {
            if (metaObj instanceof MetaListViewColumn) {
                controlType = ((MetaListViewColumn)metaObj).getColumnType();
                dictProperties = (MetaDictProperties)((MetaListViewColumn)metaObj).getProperties();
                columnKey = ((MetaListViewColumn)metaObj).getDataColumnKey();
                tableKey = ((MetaListViewColumn)metaObj).getTableKey();
            } else if (metaObj instanceof MetaEditViewColumn) {
                controlType = ((MetaEditViewColumn)metaObj).getColumnType();
                dictProperties = (MetaDictProperties)((MetaEditViewColumn)metaObj).getProperties();
                columnKey = ((MetaEditViewColumn)metaObj).getDataColumnKey();
                tableKey = ((MetaEditViewColumn)metaObj).getTableKey();
            } else if (metaObj instanceof MetaComponent) {
                metaDataBinding = ((MetaComponent)metaObj).getDataBinding();
                controlType = ((MetaComponent)metaObj).getControlType();
                dictProperties = (MetaDictProperties)((MetaComponent)metaObj).getProperties();
                columnKey = metaDataBinding.getColumnKey();
                tableKey = metaDataBinding.getTableKey();
            } else if (metaObj instanceof MetaGridCell) {
                metaDataBinding = ((MetaGridCell)metaObj).getDataBinding();
                controlType = ((MetaGridCell)metaObj).getCellType();
                dictProperties = (MetaDictProperties)((MetaGridCell)metaObj).getProperties();
                columnKey = metaDataBinding.getColumnKey();
                tableKey = ((MetaGridCell)metaObj).getTableKey();
            }
            this.getDictData(document, map, controlType, dictProperties, tableKey, columnKey);
        }
        List list = null;
        ArrayList<Long> oids = null;
        ICache cache = null;
        ArrayList<Item> captionList = new ArrayList<Item>();
        HashMap<String, List<Long>> notExists = new HashMap<String, List<Long>>();
        for (String key : map.keySet()) {
            oids = new ArrayList<Long>();
            list = (List)map.get(key);
            cache = this.itemCaches.getItemCache(key);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                if (cache.existItem(l)) continue;
                oids.add(l);
            }
            if (oids.size() <= 0) continue;
            notExists.put(key, oids);
        }
        if (notExists != null && notExists.size() > 0) {
            this.service.batchLoadItems(notExists, new Callback<String, ICache>(){

                public ICache call(String itemKey) throws Throwable {
                    return DictCacheProxy.this.itemCaches.getItemCache(itemKey);
                }
            });
        }
        for (String key : map.keySet()) {
            list = (List)map.get(key);
            cache = this.itemCaches.getItemCache(key);
            captionList.addAll(cache.getItems(list));
        }
        return captionList;
    }

    private List<AbstractMetaObject> getDictFields(MetaForm metaForm) {
        ArrayList<AbstractMetaObject> fields = new ArrayList<AbstractMetaObject>();
        List comps = metaForm.getAllComponents();
        MetaDataBinding metaDataBinding = null;
        for (MetaComponent comp : comps) {
            MetaListViewColumnCollection columnCollection;
            int controlType = comp.getControlType();
            if (controlType == 206 || controlType == 242 || controlType == 241) {
                metaDataBinding = comp.getDataBinding();
                if (metaDataBinding == null || metaDataBinding.getColumnKey() == null || metaDataBinding.getColumnKey().isEmpty()) continue;
                fields.add((AbstractMetaObject)comp);
                continue;
            }
            if (controlType == 216) {
                columnCollection = ((MetaListView)comp).getColumnCollection();
                for (MetaListViewColumn column : columnCollection) {
                    if (column.getColumnType() != 206 || column.getDataColumnKey() == null || column.getDataColumnKey().isEmpty()) continue;
                    fields.add((AbstractMetaObject)column);
                }
                continue;
            }
            if (controlType != 305) continue;
            columnCollection = ((MetaEditView)comp).getColumnCollection();
            for (MetaListViewColumn column : columnCollection) {
                if (column.getColumnType() != 206 || column.getDataColumnKey() == null || column.getDataColumnKey().isEmpty()) continue;
                fields.add((AbstractMetaObject)column);
            }
        }
        List cells = metaForm.getAllGridCells();
        for (MetaGridCell cell : cells) {
            int controlType = cell.getCellType();
            if (controlType != 206 && controlType != 242 && controlType != 241 || (metaDataBinding = cell.getDataBinding()) == null || metaDataBinding.getColumnKey() == null || metaDataBinding.getColumnKey().isEmpty()) continue;
            fields.add((AbstractMetaObject)cell);
        }
        return fields;
    }

    private void getDictData(Document document, Map<String, List<Long>> map, int controlType, MetaDictProperties dictProperties, String tableKey, String columnKey) {
        DataTable table = document.get(tableKey);
        if (table == null) {
            return;
        }
        int colIndex = table.getMetaData().findColumnIndexByKey(columnKey);
        if (colIndex == -1) {
            return;
        }
        String itemKey = null;
        if (table.first()) {
            while (!table.isAfterLast()) {
                Object value = table.getObject(colIndex);
                if (value == null) {
                    table.next();
                    continue;
                }
                switch (controlType) {
                    case 206: {
                        itemKey = dictProperties.getItemKey();
                        break;
                    }
                    case 241: 
                    case 242: {
                        int col = table.getMetaData().findColumnIndexByKey(columnKey + "ItemKey");
                        itemKey = col != -1 ? table.getString(col) : "";
                    }
                }
                if (itemKey != null && !itemKey.isEmpty()) {
                    if (dictProperties.isAllowMultiSelection().booleanValue()) {
                        Long[] oids;
                        String ids = TypeConvertor.toString((Object)value);
                        if (ids.length() > 0 && (oids = TypeConvertor.toLongArray((Object)ids.split(","))).length > 0) {
                            for (Long oid : oids) {
                                this.addDictItems(map, itemKey, oid);
                            }
                        }
                    } else {
                        long oid = TypeConvertor.toLong((Object)value);
                        this.addDictItems(map, itemKey, oid);
                    }
                }
                table.next();
            }
        }
    }

    private void addDictItems(Map<String, List<Long>> map, String itemKey, Long oid) {
        if (itemKey != null && !itemKey.isEmpty() && oid > 0L) {
            List<Long> oids;
            if (!map.containsKey(itemKey)) {
                map.put(itemKey, new ArrayList());
            }
            if (!(oids = map.get(itemKey)).contains(oid)) {
                oids.add(oid);
            }
        }
    }

    @Override
    public void removeDictCache(String itemKey) {
        try {
            this.itemCaches.getItemCache(itemKey).clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Item> getAllItems(String itemKey, IItemFilter filter, int formState, int stateMask) throws Throwable {
        ICache cache = this.itemCaches.getItemCache(itemKey);
        List<Item> list = this.service.getAllItems(itemKey, filter, formState, stateMask);
        cache.addItems(list);
        return list;
    }

    private Item loadItems(ICache cache, String itemKey, long oid) throws Throwable {
        ArrayList<Long> oids = new ArrayList<Long>();
        oids.add(oid);
        List<Item> list = this.loadItems(cache, itemKey, oids);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private List<Item> loadItems(ICache cache, String itemKey, List<Long> oids) throws Throwable {
        List<Item> list = this.service.loadItems(itemKey, oids);
        cache.addItems(list);
        return list;
    }

    @Override
    public void sortDictItem(String itemKey, List<Item> list) {
        try {
            if (list != null && list.size() > 0) {
                ICache cache = this.itemCaches.getItemCache(itemKey);
                Collections.sort(list, new ItemSortComparator(cache));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public long updateCache(String itemKey, long oid) throws Throwable {
        ICache cache = this.itemCaches.getItemCache(itemKey);
        return cache.update(oid);
    }

    @Override
    public void clear() {
        this.itemCaches.clear();
    }

    @Override
    public int getLookupCount(String itemKey, String fuzzyFields, String fuzzyValue, IItemFilter filter, ItemData root, int stateMask, int queryMatchType, String formKey, String fieldKey, int formState) throws Throwable {
        return -1;
    }

    @Override
    public Item getItemByCode(String itemKey, String code) throws Throwable {
        return null;
    }
}

