/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.init;

import com.bokesoft.yes.base.MidAppException;
import com.bokesoft.yes.common.encrypt.RSA;
import com.bokesoft.yes.common.log.ILogSvr;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.i18n.StringTable;
import com.bokesoft.yes.log.NullLogSvr;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.DBDSNItem;
import com.bokesoft.yes.mid.base.DSNItem;
import com.bokesoft.yes.mid.base.DSNItemCollection;
import com.bokesoft.yes.mid.base.SecuritySetting;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.base.VariantSetting;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yes.report.util.ReportUtil;
import com.bokesoft.yes.tools.env.ResolverProfile;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.connection.DBType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import org.apache.commons.codec.binary.Hex;

public class SystemPropertiesInit {
    public void init() throws Throwable {
        this.initEnv();
        this.initCore();
        this.initServerSetting();
        this.initVariant();
        this.initDSNS();
        this.initSeuritySetting();
    }

    private void initEnv() throws Throwable {
        LogSvr.setInstance((ILogSvr)new NullLogSvr());
        URL url = Thread.currentThread().getContextClassLoader().getResource("core.properties");
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource("");
        }
        String path = URLDecoder.decode(url.getPath(), "utf-8");
        path = path.substring(0, path.lastIndexOf(47) + 1);
        SvrInfo.setWorkDir((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCore() throws Throwable {
        CoreSetting coreSetting = CoreSetting.getInstance((boolean)true);
        try (Reader coreIs = null;){
            String guestKick;
            String kick;
            String cache;
            String cache2;
            coreIs = PropertyUtil.readProperties2reader((String)"core.properties");
            if (coreIs == null) {
                throw new MidCoreException(45, MidCoreException.formatMessage(null, (int)45, (Object[])new Object[]{"core.properties"}));
            }
            PropertyResourceBundle coreBundle = new PropertyResourceBundle(coreIs);
            if (coreBundle.containsKey("SolutionPath")) {
                String s;
                String solutionPath = coreBundle.getString("SolutionPath").trim();
                coreSetting.setSolutionPath(solutionPath.replaceAll("//", "/"));
                String pluginsPath = solutionPath + File.separatorChar + "Enhance";
                if (coreBundle.containsKey("PluginsPath") && !StringUtil.isBlankOrNull((String)(s = coreBundle.getString("PluginsPath").trim()))) {
                    pluginsPath = s;
                }
                coreSetting.setPluginsSourcePath(pluginsPath.replace("//", "/"));
            } else if (!coreBundle.containsKey("SOLUTIONS")) {
                throw new MidAppException(5, MidAppException.formatMessage(null, 5, new Object[0]));
            }
            String logSvrImpl = null;
            if (coreBundle.containsKey("LOGSVR")) {
                logSvrImpl = coreBundle.getString("LOGSVR");
                coreSetting.setLogSvr(logSvrImpl);
            }
            if (coreBundle.containsKey("DEFAULTAPP")) {
                String appKey = coreBundle.getString("DEFAULTAPP");
                coreSetting.setAppKey(appKey);
            }
            if (coreBundle.containsKey("APPID")) {
                String appID = coreBundle.getString("APPID");
                coreSetting.setAppID(appID);
            }
            if (coreBundle.containsKey("RightChkLevel")) {
                String rightChkLevel = coreBundle.getString("RightChkLevel");
                coreSetting.setRightChkLevel(rightChkLevel);
            }
            if (coreBundle.containsKey("SOLUTIONS")) {
                this.dealwithSolutions(coreBundle, coreSetting);
            }
            if (coreBundle.containsKey("DictMatchUpper")) {
                boolean b = TypeConvertor.toBoolean((Object)coreBundle.getString("DictMatchUpper"));
                coreSetting.setDictMatchUpper(b);
            }
            String dsn = null;
            if (coreBundle.containsKey("DSN")) {
                dsn = coreBundle.getString("DSN");
                coreSetting.setDSN(dsn);
            }
            String defaultDSN = null;
            if (coreBundle.containsKey("DEFAULT")) {
                defaultDSN = coreBundle.getString("DEFAULT");
                coreSetting.setDefaultDSN(defaultDSN);
            }
            if (coreBundle.containsKey("DefaultArchiveDSN")) {
                String defaultArchiveDSN = coreBundle.getString("DefaultArchiveDSN");
                coreSetting.setDefaultArchiveDSN(defaultArchiveDSN);
            }
            if (coreBundle.containsKey("DEBUG")) {
                String debug = coreBundle.getString("DEBUG");
                if (debug != null && debug.equalsIgnoreCase("true")) {
                    SvrInfo.setNeedDebug((boolean)true);
                } else {
                    SvrInfo.setNeedDebug((boolean)false);
                }
            }
            if (coreBundle.containsKey("LogServicePackage")) {
                String s = coreBundle.getString("LogServicePackage");
                SvrInfo.setLogServicePackage((boolean)Boolean.parseBoolean(s));
            }
            String cacheName = "simple";
            if (coreBundle.containsKey("Cache") && (cache2 = coreBundle.getString("Cache")) != null && !cache2.isEmpty()) {
                cacheName = cache2;
            }
            if (coreBundle.containsKey("CACHE") && (cache2 = coreBundle.getString("CACHE")) != null && !cache2.isEmpty()) {
                cacheName = cache2;
            }
            SvrInfo.setCacheName((String)cacheName.toLowerCase());
            String sessionCache = SvrInfo.getCacheName();
            if (coreBundle.containsKey("SessionCache") && (cache = coreBundle.getString("SessionCache")) != null && !cache.isEmpty()) {
                sessionCache = cache;
            }
            if (coreBundle.containsKey("SESSIONCACHE") && (cache = coreBundle.getString("SESSIONCACHE")) != null && !cache.isEmpty()) {
                sessionCache = cache;
            }
            SvrInfo.setSessionCacheName((String)sessionCache.toLowerCase());
            if (coreBundle.containsKey("KICK")) {
                kick = coreBundle.getString("KICK");
                if (kick != null && kick.equalsIgnoreCase("false")) {
                    SvrInfo.setKick((boolean)false);
                } else {
                    SvrInfo.setKick((boolean)true);
                }
            }
            if (coreBundle.containsKey("Kick")) {
                kick = coreBundle.getString("Kick");
                if (kick != null && kick.equalsIgnoreCase("false")) {
                    SvrInfo.setKick((boolean)false);
                } else {
                    SvrInfo.setKick((boolean)true);
                }
            }
            if (coreBundle.containsKey("GuestKick")) {
                guestKick = coreBundle.getString("GuestKick");
                if (guestKick != null && guestKick.equalsIgnoreCase("false")) {
                    SvrInfo.setGuestKick((boolean)false);
                } else {
                    SvrInfo.setGuestKick((boolean)true);
                }
            }
            if (coreBundle.containsKey("GUESTKICK")) {
                guestKick = coreBundle.getString("GUESTKICK");
                if (guestKick != null && guestKick.equalsIgnoreCase("false")) {
                    SvrInfo.setGuestKick((boolean)false);
                } else {
                    SvrInfo.setGuestKick((boolean)true);
                }
            }
        }
    }

    protected void initDSNS() throws Throwable {
        String dsns = CoreSetting.getInstance().getDSN();
        if (dsns == null || dsns.isEmpty()) {
            return;
        }
        DSNItemCollection dsnCollection = CoreSetting.getInstance().getDSNCollection();
        String defaultDSN = CoreSetting.getInstance().getDefaultDSN();
        String defaultArchiveDSN = CoreSetting.getInstance().getDefaultArchiveDSN();
        ServerSetting serverSetting = ServerSetting.getInstance();
        boolean encryptDSN = serverSetting.isEncryptDSN();
        String[] vDsn = dsns.split(",");
        int length = vDsn.length;
        String firstDSN = null;
        String lastDSN = null;
        for (int i = 0; i < length; ++i) {
            InputStream extfis;
            String extConfig;
            String caseSensitive;
            String connectionFactory;
            String dbFactory;
            DBDSNItem dbItem;
            Reader fis;
            String dsn = vDsn[i];
            if (i == 0) {
                firstDSN = dsn;
            }
            if (i == length - 1) {
                lastDSN = dsn;
            }
            if ((fis = PropertyUtil.readProperties2reader((String)(dsn + ".properties"))) == null) {
                throw new MidCoreException(45, MidCoreException.formatMessage(null, (int)45, (Object[])new Object[]{dsn + ".properties"}));
            }
            PropertyResourceBundle dsnBundle = new PropertyResourceBundle(fis);
            fis.close();
            DBDSNItem item = null;
            item = dbItem = new DBDSNItem();
            dbItem.setName(dsnBundle.getString("Name"));
            String connectionTypeString = dsnBundle.getString("ConnectionType");
            if ("dbcp".equalsIgnoreCase(connectionTypeString)) {
                dbItem.setConnectionType(1);
            } else if ("jndi".equalsIgnoreCase(connectionTypeString)) {
                dbItem.setConnectionType(2);
            } else {
                dbItem.setConnectionType(0);
            }
            dbItem.setDriver(dsnBundle.getString("Driver"));
            dbItem.setURL(dsnBundle.getString("URL"));
            dbItem.setUser(dsnBundle.getString("User"));
            String password = dsnBundle.getString("Password");
            if (encryptDSN) {
                byte[] b1 = Base64.decode((byte[])password.getBytes());
                b1 = Hex.decodeHex((char[])new String(b1).toCharArray());
                String privateKey = "";
                File pklFile = new File(serverSetting.getDSNPKL());
                FileReader reader = new FileReader(pklFile);
                BufferedReader br = new BufferedReader(reader);
                br.readLine();
                privateKey = br.readLine();
                br.close();
                reader.close();
                RSA rsa = new RSA();
                b1 = rsa.decryptByPrivate(b1, privateKey);
                password = new String(b1);
            }
            dbItem.setPassword(password);
            String dbTypeString = dsnBundle.getString("DBType");
            dbItem.setDBType(DBType.parse((String)dbTypeString));
            if (dsnBundle.containsKey("DBFactory") && (dbFactory = dsnBundle.getString("DBFactory")) != null && !dbFactory.isEmpty()) {
                dbItem.setDBFactory(dbFactory);
            }
            if (dsnBundle.containsKey("ConnectionFactory") && (connectionFactory = dsnBundle.getString("ConnectionFactory")) != null && !connectionFactory.isEmpty()) {
                dbItem.setConnectionFactoryClazz(connectionFactory);
            }
            if (dsnBundle.containsKey("CASE_SENSITIVE") && (caseSensitive = dsnBundle.getString("CASE_SENSITIVE")) != null && !caseSensitive.isEmpty()) {
                dbItem.addExtProp("CASE_SENSITIVE", caseSensitive);
            }
            if (dsnBundle.containsKey("ExtConfig") && (extConfig = dsnBundle.getString("ExtConfig")) != null && !extConfig.isEmpty() && (extfis = PropertyUtil.readProperties((String)(extConfig + ".properties"))) != null) {
                PropertyResourceBundle extConfigBundle = new PropertyResourceBundle(extfis);
                extfis.close();
                Enumeration<String> extPropKeys = extConfigBundle.getKeys();
                while (extPropKeys.hasMoreElements()) {
                    String extPropKey = extPropKeys.nextElement();
                    String extPropValue = extConfigBundle.getString(extPropKey);
                    dbItem.addExtProp(extPropKey, extPropValue);
                }
            }
            dsnCollection.addDSNItem((DSNItem)item);
        }
        if (defaultDSN != null) {
            defaultDSN = defaultDSN.trim();
        }
        if (defaultDSN == null || defaultDSN.isEmpty()) {
            defaultDSN = firstDSN;
        }
        if (defaultDSN != null && !defaultDSN.isEmpty()) {
            DSNItem defaultDSNItem = dsnCollection.getDSNItem(defaultDSN);
            if (defaultDSNItem == null) {
                throw new MidAppException(1, SimpleStringFormat.format((String)StringTable.getString(null, "", "OneDSNUnDefined"), (Object[])new Object[0]));
            }
            dsnCollection.setDefaultDSN(defaultDSNItem);
        }
        if (defaultArchiveDSN != null) {
            defaultArchiveDSN = defaultArchiveDSN.trim();
        }
        if (defaultArchiveDSN == null || defaultArchiveDSN.isEmpty()) {
            defaultArchiveDSN = lastDSN;
        }
        if (defaultArchiveDSN != null && !defaultDSN.isEmpty()) {
            DSNItem defaultArchiveDSNItem = dsnCollection.getDSNItem(defaultArchiveDSN);
            if (defaultArchiveDSNItem == null) {
                throw new MidAppException(1, SimpleStringFormat.format((String)StringTable.getString(null, "", "OneDSNUnDefined"), (Object[])new Object[0]));
            }
            dsnCollection.setDefaultArchiveDSN(defaultArchiveDSNItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealwithSolutions(PropertyResourceBundle coreBundle, CoreSetting coreSetting) throws Throwable {
        String s = coreBundle.getString("SOLUTIONS").trim();
        if (StringUtil.isBlankOrNull((String)s)) {
            return;
        }
        String[] solutions = s.split(",");
        ArrayList<ResolverProfile> profiles = new ArrayList<ResolverProfile>();
        ResolverProfile profile = null;
        boolean flag = false;
        for (String solution : solutions) {
            profile = new ResolverProfile();
            profile.setKey(solution);
            PropertyResourceBundle bundle = null;
            try (Reader reader = null;){
                reader = PropertyUtil.readProperties2reader((String)(solution + ".properties"));
                if (reader != null) {
                    bundle = new PropertyResourceBundle(reader);
                    Enumeration<String> keys = bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        if (key.equals("IMPL")) {
                            String impl = bundle.getString("IMPL");
                            if (StringUtil.isBlankOrNull((String)impl)) continue;
                            profile.setImpl(impl);
                            continue;
                        }
                        if (key.equals("PRIMARY")) {
                            String primary = bundle.getString("PRIMARY");
                            if (StringUtil.isBlankOrNull((String)primary)) continue;
                            flag = true;
                            profile.setPrimary(TypeConvertor.toBoolean((Object)primary).booleanValue());
                            continue;
                        }
                        if (key.equals("DIFF")) {
                            String diff = bundle.getString("DIFF");
                            if (StringUtil.isBlankOrNull((String)diff)) continue;
                            profile.setDiff(TypeConvertor.toBoolean((Object)diff).booleanValue());
                            continue;
                        }
                        if (!key.startsWith("PARA.")) continue;
                        String paraKey = key.substring(5);
                        String paraValue = bundle.getString(key);
                        if (paraKey.isEmpty() || StringUtil.isBlankOrNull((String)paraValue)) continue;
                        if (paraKey.equals("SOLUTIONPATH")) {
                            paraValue = paraValue.trim().replaceAll("//", "/");
                        }
                        profile.putPara(paraKey, (Object)paraValue);
                    }
                    profiles.add(profile);
                    continue;
                }
                throw new MidCoreException(45, MidCoreException.formatMessage(null, (int)45, (Object[])new Object[]{solution + ".properties"}));
            }
        }
        if (profiles.size() > 0) {
            coreSetting.setSolutions(profiles);
            if (!flag) {
                ((ResolverProfile)profiles.get(0)).setPrimary(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServerSetting() throws Throwable {
        ServerSetting serverSetting = ServerSetting.getInstance((boolean)true);
        Reader serverIs = PropertyUtil.readProperties2reader((String)"server.properties");
        if (serverIs != null) {
            try {
                PropertyResourceBundle serverBundle = new PropertyResourceBundle(serverIs);
                String s = serverBundle.getString("EncryptDSN");
                if (s != null && s.equalsIgnoreCase("true")) {
                    serverSetting.setEncryptDSN(true);
                    String dsnPKL = serverBundle.getString("DSNPKL");
                    if (dsnPKL == null || dsnPKL.isEmpty()) {
                        dsnPKL = SvrInfo.getWorkDir() + "dsn.pkl";
                    }
                    serverSetting.setDSNPKL(dsnPKL);
                }
                if ((s = serverBundle.getString("FileSessionPKL")) != null && s.equalsIgnoreCase("true")) {
                    serverSetting.setFileSessionPKL(true);
                    String sessionPKL = serverBundle.getString("SessionPKL");
                    if (sessionPKL == null || sessionPKL.isEmpty()) {
                        sessionPKL = SvrInfo.getWorkDir() + "session.pkl";
                    }
                    serverSetting.setSessionPKL(sessionPKL);
                }
                if (serverBundle.containsKey("ValidateLevel") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("ValidateLevel")))) {
                    String[] arr;
                    for (String tmp : arr = StringUtil.split((String)s, (String)",")) {
                        serverSetting.addValidateLevel(TypeConvertor.toInteger((Object)tmp).intValue());
                    }
                }
                if (serverBundle.containsKey("SecurityLevel") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SecurityLevel")))) {
                    serverSetting.setSecurityLevel(TypeConvertor.toInteger((Object)s).intValue());
                }
                if (serverBundle.containsKey("ValidateCreator") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("ValidateCreator")))) {
                    serverSetting.setValidateCreator(s);
                }
                if (serverBundle.containsKey("CertificatePath") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("CertificatePath")))) {
                    serverSetting.setCertificatePath(s);
                }
                if (serverBundle.containsKey("CertificateWarehouseCreator") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("CertificateWarehouseCreator")))) {
                    serverSetting.setCertificateWarehouseCreator(s);
                }
                if (serverBundle.containsKey("SessionKeepTime") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SessionKeepTime")))) {
                    serverSetting.setSessionKeepTime(TypeConvertor.toLong((Object)s));
                }
                if (serverBundle.containsKey("TicketIDClearPeriod") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("TicketIDClearPeriod")))) {
                    serverSetting.setTicketIDClearPeriod(TypeConvertor.toLong((Object)s));
                }
                if (serverBundle.containsKey("PasswordRule") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("PasswordRule")))) {
                    serverSetting.setPasswordRule(TypeConvertor.toString((Object)s));
                }
                if (serverBundle.containsKey("SupportHotDeploy") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SupportHotDeploy")))) {
                    serverSetting.setSupportHotDeploy(TypeConvertor.toBoolean((Object)s).booleanValue());
                }
                if (serverBundle.containsKey("AllowHotDeployTest") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("AllowHotDeployTest")))) {
                    serverSetting.setAllowHotDeployTest(TypeConvertor.toBoolean((Object)s).booleanValue());
                }
                if (serverBundle.containsKey("UseVariant") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("UseVariant")))) {
                    serverSetting.setUseVariant(TypeConvertor.toBoolean((Object)s).booleanValue());
                }
                if (serverBundle.containsKey("SchemaCreateFactory") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SchemaCreateFactory")))) {
                    serverSetting.setSchemaCreateFactory(s);
                }
                if (serverBundle.containsKey("SchemaCheckFactory") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SchemaCheckFactory")))) {
                    serverSetting.setSchemaCheckFactory(s);
                }
                if (serverBundle.containsKey("DeviationWidthAwt2pdf") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("DeviationWidthAwt2pdf")))) {
                    ReportUtil.setDeviationWidthAwt2pdf((int)TypeConvertor.toInteger((Object)s));
                }
                if ((s = serverBundle.getString("Master")) != null) {
                    if (s.equalsIgnoreCase("true")) {
                        serverSetting.setMaster(true);
                    } else {
                        serverSetting.setMaster(false);
                    }
                }
                if (serverBundle.containsKey("NodePort")) {
                    s = serverBundle.getString("NodePort");
                    serverSetting.setNodePort(s);
                }
                if (serverBundle.containsKey("StatusReceiverPort")) {
                    s = serverBundle.getString("StatusReceiverPort");
                    serverSetting.setStatusReceiverPort(s);
                }
                if (serverBundle.containsKey("NodeInstanceID")) {
                    s = serverBundle.getString("NodeInstanceID");
                    serverSetting.setNodeInstanceID(s);
                }
                if (serverBundle.containsKey("DSNFactory")) {
                    s = serverBundle.getString("DSNFactory");
                    serverSetting.setDSNFactory(s);
                }
            }
            finally {
                if (serverIs != null) {
                    serverIs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSeuritySetting() throws Throwable {
        SecuritySetting serverSetting = SecuritySetting.getInstance((boolean)true);
        Reader securityIs = PropertyUtil.readProperties2reader((String)"security.properties");
        if (securityIs != null) {
            try {
                PropertyResourceBundle bundle = new PropertyResourceBundle(securityIs);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.startsWith("ResponseHead.")) continue;
                    String paraKey = key.substring(13);
                    String paraValue = bundle.getString(key);
                    if (paraKey.isEmpty() || StringUtil.isBlankOrNull((String)paraValue)) continue;
                    serverSetting.addResponseHead(paraKey, paraValue);
                }
            }
            finally {
                if (securityIs != null) {
                    securityIs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVariant() throws Throwable {
        VariantSetting setting = VariantSetting.getInstance((boolean)true);
        Reader vis = PropertyUtil.readProperties2reader((String)"variant.properties");
        if (vis != null) {
            try {
                PropertyResourceBundle vbundle = new PropertyResourceBundle(vis);
                String s = null;
                if (vbundle.containsKey("SourceType") && !StringUtil.isBlankOrNull((String)(s = vbundle.getString("SourceType")))) {
                    int type = setting.parse(s);
                    setting.setSourceType(type);
                }
                if (vbundle.containsKey("KeyGeneratorClass") && !StringUtil.isBlankOrNull((String)(s = vbundle.getString("KeyGeneratorClass")))) {
                    setting.setKeyGeneratorClass(s);
                }
                if (vbundle.containsKey("VariantIOFactoryClass") && !StringUtil.isBlankOrNull((String)(s = vbundle.getString("VariantIOFactoryClass")))) {
                    setting.setVariantIOFactoryClass(s);
                }
            }
            finally {
                if (vis != null) {
                    vis.close();
                }
            }
        }
    }
}

