/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.init;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.meta.json.MetaProcessJsonUnserializer;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.process.IJsonUnserializer;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.json.JSONObject;

public class PreLoadProcessInDB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(DefaultContext context) throws Throwable {
        if (context.getVE().getDSN() == null) {
            return;
        }
        IDBManager DBManager = context.getDBManager();
        String sql = "select " + DBManager.keyWordEscape("ProcessKey") + "," + DBManager.keyWordEscape("VerID") + "," + DBManager.keyWordEscape("Caption") + "," + DBManager.keyWordEscape("Defination") + "," + DBManager.keyWordEscape("AlreadyDeploy") + " from " + DBManager.keyWordEscape("BPM_Process");
        Statement ps = null;
        ResultSet rs = null;
        try {
            IMetaFactory factory = context.getVE().getMetaFactory();
            ps = DBManager.preparedQueryStatement(sql);
            rs = DBManager.executeQuery((PreparedStatement)ps, sql, null);
            while (rs.next()) {
                String processKey = rs.getString(1);
                int verID = rs.getInt(2);
                String caption = rs.getString(3);
                String definationString = rs.getString(4);
                int alreadyDeploy = rs.getInt(5);
                JSONObject definationJson = null;
                if (definationString != null && definationString.length() > 0) {
                    definationJson = new JSONObject(definationString);
                }
                ProcessDefinitionProfile processProfile = new ProcessDefinitionProfile();
                processProfile.setKey(processKey);
                processProfile.setCaption(caption);
                processProfile.setVersion(verID);
                processProfile.setDefinationJson(definationJson);
                processProfile.setJsonUnserializer((IJsonUnserializer)new MetaProcessJsonUnserializer());
                processProfile.setSourceType("DB");
                if (factory.getMetaBPM().getProfileMap().containsKey(processKey + "_V" + verID)) {
                    LogSvr.getInstance().debug("\u6d41\u7a0b\u7248\u672c\u91cd\u590d\uff1a" + processKey + "_V" + verID);
                }
                factory.getMetaBPM().getProfileMap().put(processKey + "_V" + verID, processProfile);
                if (alreadyDeploy != 1) continue;
                MetaProcessDeployInfo deployInfo = new MetaProcessDeployInfo();
                deployInfo.setKey(processKey);
                deployInfo.setVersion(Integer.valueOf(verID));
                factory.getMetaBPM().getMetaBPMDeployInfoCollection().add((KeyPairMetaObject)deployInfo);
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }
}

