/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.init;

import com.bokesoft.yes.base.MidAppException;
import com.bokesoft.yes.bpm.BPMMidFunction.BPMMidFunctionProvider;
import com.bokesoft.yes.bpm.predict.handler.BPMNodePredictHandlerFactory;
import com.bokesoft.yes.bpm.predict.handler.IBPMNodePredictHandlerFactory;
import com.bokesoft.yes.bpm.predict.handler.MidBPMNodePredictHandlerFactory;
import com.bokesoft.yes.bpm.schema.BPMSchemaProxyFactory;
import com.bokesoft.yes.bpm.schema.DefaultBPMSchemaProxyFactory;
import com.bokesoft.yes.bpm.schema.IBPMSchemaProxyFactory;
import com.bokesoft.yes.bpm.service.BPMDataMigrationFactory;
import com.bokesoft.yes.bpm.service.KillInstancesFactory;
import com.bokesoft.yes.bpm.service.LoadBPMFactory;
import com.bokesoft.yes.bpm.service.SaveBPMDataMapFactory;
import com.bokesoft.yes.bpm.timer.EvictExpiredDelegateJob;
import com.bokesoft.yes.bpm.timer.ExecTimeoutItemJob;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.ReflectUtil;
import com.bokesoft.yes.datamap.function.DocumentFunctionProvider;
import com.bokesoft.yes.design.function.DesignMidFunctionProvider;
import com.bokesoft.yes.dsn.DefaultDSNFactory;
import com.bokesoft.yes.excel.parser.ExcelMidFunctionProvider;
import com.bokesoft.yes.i18n.StringTable;
import com.bokesoft.yes.init.DBMaintainceListener;
import com.bokesoft.yes.init.PreLoadProcessInDB;
import com.bokesoft.yes.log.NullLogSvr;
import com.bokesoft.yes.log.log4j.LogSvrImpl;
import com.bokesoft.yes.meta.persist.dom.deploy.MetaDeployLoad;
import com.bokesoft.yes.mid.auth.cache.simple.MobileSessionInfoProvider;
import com.bokesoft.yes.mid.auth.cache.simple.OvertimeSessionInfoProvider;
import com.bokesoft.yes.mid.auth.cache.simple.SimpleSessionInfoProvider;
import com.bokesoft.yes.mid.auth.cache.simple.TempSessionInfoProvider;
import com.bokesoft.yes.mid.backgroundtask.BackgroundTask;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.DefaultMidVEFactory;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.dict.DictCacheProxyFactory;
import com.bokesoft.yes.mid.dict.DictMaintainScheduleJob;
import com.bokesoft.yes.mid.dict.DictTreeServiceProxyFactory;
import com.bokesoft.yes.mid.dict.IDictCacheProxyFactory;
import com.bokesoft.yes.mid.dict.IDictTreeServiceProxyFactory;
import com.bokesoft.yes.mid.dict.MidDictItemCacheFactory;
import com.bokesoft.yes.mid.dict.proxy.MidDictCacheProxyFactory;
import com.bokesoft.yes.mid.dict.proxy.MidDictTreeServiceProxyFactory;
import com.bokesoft.yes.mid.dsn.DSNFactory;
import com.bokesoft.yes.mid.function.MidFunctionProvider;
import com.bokesoft.yes.mid.hotdeploy.MidEnvManager;
import com.bokesoft.yes.mid.hotdeploy.MidGlobalEnvState;
import com.bokesoft.yes.mid.oid.OIDAllocatorFactory;
import com.bokesoft.yes.mid.oid.impl.MidOIDAllocatorFactory;
import com.bokesoft.yes.mid.parser.MidFunctionImplMap;
import com.bokesoft.yes.mid.redis.RedisCacheFactory;
import com.bokesoft.yes.mid.redis.RedisConnectionFactory;
import com.bokesoft.yes.mid.right.FormRightsProxyFactory;
import com.bokesoft.yes.mid.rights.IFormRightsProxyFactory;
import com.bokesoft.yes.mid.rights.IRightsProviderFactory;
import com.bokesoft.yes.mid.rights.MidUserRightsFactory;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.scheduler.job.EvictExpiredSessionJob;
import com.bokesoft.yes.mid.schemamgr.MidSchemaCheckFactory;
import com.bokesoft.yes.mid.schemamgr.MidSchemaCreateFactory;
import com.bokesoft.yes.mid.service.MidProcessFlowHandler;
import com.bokesoft.yes.mid.service.datamap.DataMapLogicCheckFactory;
import com.bokesoft.yes.mid.servicerights.DefaultServiceRightCheckerFactory;
import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yes.mid.simple.SimpleCacheFactory;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yes.rights.DefaultFormRightsProxyFactory;
import com.bokesoft.yes.struct.document.DocumentFunctionMap;
import com.bokesoft.yes.tools.dic.item.DictItemCacheFactory;
import com.bokesoft.yes.tools.dic.item.IDictItemCacheFactory;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICacheFactory;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.log.ILogSvr;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.deploy.MetaDeploy;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtStartListener;
import com.bokesoft.yigo.meta.enhance.MetaStartListener;
import com.bokesoft.yigo.meta.factory.FileResourceResolver;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaIOProvider;
import com.bokesoft.yigo.meta.setting.MetaIOService;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.document.io.DocumentIOFactory;
import com.bokesoft.yigo.mid.document.io.IOFactory;
import com.bokesoft.yigo.mid.dsn.IDSNFactory;
import com.bokesoft.yigo.mid.nosql.ConnectionFactory;
import com.bokesoft.yigo.mid.nosql.IConnectionFactory;
import com.bokesoft.yigo.mid.oid.IOIDAllocatorFactory;
import com.bokesoft.yigo.mid.scheduler.QuartzManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCheckFactory;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreateFactory;
import com.bokesoft.yigo.mid.schemamgr.SchemaCheckFactory;
import com.bokesoft.yigo.mid.schemamgr.SchemaCreateFactory;
import com.bokesoft.yigo.mid.service.IServiceProcessFactory;
import com.bokesoft.yigo.mid.service.IServiceRightCheckerFactory;
import com.bokesoft.yigo.mid.service.ServiceRightCheckerFactory;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionCacheFactory;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.mid.start.IStartListener;
import com.bokesoft.yigo.parser.IFunctionProvider;
import com.bokesoft.yigo.session.RedisSessionCacheFactory;
import com.bokesoft.yigo.session.SimpleSessionCacheFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.quartz.Job;

public class MidSystemInit {
    private ArrayList<IStartListener> listeners = new ArrayList();
    private boolean startWithDSN = true;
    public static boolean initSucessed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impl_init() throws Throwable {
        MetaExtStartListener extStartListener;
        this.initSetting();
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new MidFunctionProvider());
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new DesignMidFunctionProvider());
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new ExcelMidFunctionProvider());
        DocumentFunctionMap.getDataTableInstance().regFunctionProvider((IFunctionProvider)new DocumentFunctionProvider());
        DictItemCacheFactory.setInstance((IDictItemCacheFactory)new MidDictItemCacheFactory());
        RightsProviderFactory.setInstance((IRightsProviderFactory)new MidUserRightsFactory());
        FormRightsProxyFactory.setInstance((IFormRightsProxyFactory)new DefaultFormRightsProxyFactory());
        BPMSchemaProxyFactory.setInstance((IBPMSchemaProxyFactory)new DefaultBPMSchemaProxyFactory());
        DictTreeServiceProxyFactory.setInstance((IDictTreeServiceProxyFactory)new MidDictTreeServiceProxyFactory());
        DictCacheProxyFactory.setInstance((IDictCacheProxyFactory)new MidDictCacheProxyFactory());
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new BPMMidFunctionProvider());
        ServiceRightCheckerFactory.setInstance((IServiceRightCheckerFactory)new DefaultServiceRightCheckerFactory());
        MidGlobalEnv midEnv = MidGlobalEnv.getInstance();
        ServerSetting setting = ServerSetting.getInstance();
        Object createfactory = null;
        createfactory = setting.getSchemaCreateFactory() != null && !setting.getSchemaCreateFactory().isEmpty() ? (ISchemaCreateFactory)ReflectHelper.newInstanceByClassLoader((ClassLoader)midEnv.getPluginsClassLoader(), (String)setting.getSchemaCreateFactory()) : new MidSchemaCreateFactory();
        SchemaCreateFactory.setInstance((ISchemaCreateFactory)createfactory);
        Object checkfactory = null;
        checkfactory = setting.getSchemaCheckFactory() != null && !setting.getSchemaCheckFactory().isEmpty() ? (ISchemaCheckFactory)ReflectHelper.newInstanceByClassLoader((ClassLoader)midEnv.getPluginsClassLoader(), (String)setting.getSchemaCheckFactory()) : new MidSchemaCheckFactory();
        SchemaCheckFactory.setInstance((ISchemaCheckFactory)checkfactory);
        OIDAllocatorFactory.setInstance((IOIDAllocatorFactory)new MidOIDAllocatorFactory());
        BPMNodePredictHandlerFactory.setInstance((IBPMNodePredictHandlerFactory)new MidBPMNodePredictHandlerFactory());
        MetaEnhance enhance = midEnv.getMetaFactory().getEnhance("");
        if (enhance != null && (extStartListener = enhance.getStartListener()) != null) {
            for (int i = 0; i < extStartListener.size(); ++i) {
                MetaStartListener metaListener = (MetaStartListener)extStartListener.get(i);
                String implPath = metaListener.getImpl();
                IStartListener listener = (IStartListener)ReflectHelper.newInstanceByClassLoader((ClassLoader)midEnv.getPluginsClassLoader(), (String)implPath);
                this.listeners.add(listener);
            }
        }
        DefaultMidVEFactory veFactory = new DefaultMidVEFactory();
        try (DefaultContext context = new DefaultContext(veFactory.createVE());){
            IMetaFactory metaFactory = context.getVE().getMetaFactory();
            metaFactory.initParaTable();
            metaFactory.preLoadEntity();
            String cacheName = SvrInfo.getCacheName();
            this.initCacheFactory(cacheName, metaFactory);
            String sessionCacheName = SvrInfo.getSessionCacheName();
            this.initSessionCacheFactory(sessionCacheName, metaFactory);
            this.initConnectionFactory(cacheName, sessionCacheName);
            this.initSessionCacheInfo(metaFactory);
            this.initAccountLockoutInfo(metaFactory);
            DBMaintainceListener dbMaintain = new DBMaintainceListener();
            dbMaintain.invoke(context);
            context.commit();
            PreLoadProcessInDB preLoadProcessInDB = new PreLoadProcessInDB();
            preLoadProcessInDB.load(context);
            this.doStartListener(context);
            context.commit();
            this.midProcessInit();
            this.midQuartzStart(context);
            this.doBackgroundTask(context);
            context.commit();
        }
    }

    private void initConnectionFactory(String cacheName, String sessionCacheName) {
        if (cacheName.equals("redis") || sessionCacheName.equals("redis")) {
            ConnectionFactory.setInstance((IConnectionFactory)new RedisConnectionFactory());
        }
    }

    public void init() throws Throwable {
        try {
            this.impl_init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            initSucessed = false;
            MetaFactory.setGlobalInstance(null);
            LogSvr.getInstance().info("\u5e94\u7528\u521d\u59cb\u5316\u5931\u8d25");
            throw e;
        }
    }

    private void doStartListener(DefaultContext context) throws Throwable {
        if (!this.startWithDSN) {
            return;
        }
        Iterator<IStartListener> it = this.listeners.iterator();
        IStartListener listener = null;
        while (it.hasNext()) {
            listener = it.next();
            listener.invoke(context);
        }
    }

    protected void initSetting() throws Throwable {
        LogSvr.setInstance((com.bokesoft.yes.common.log.ILogSvr)new NullLogSvr());
        CoreSetting coreSetting = CoreSetting.getInstance();
        ServerSetting serverSetting = ServerSetting.getInstance();
        try {
            MetaIOService IOService;
            String logSvrImpl = coreSetting.getLogSvr();
            if (logSvrImpl != null && !logSvrImpl.isEmpty()) {
                ILogSvr impl = null;
                if (logSvrImpl.indexOf(".") != -1) {
                    impl = (ILogSvr)ReflectUtil.newInstance((String)logSvrImpl);
                } else if ("log4j".equalsIgnoreCase(logSvrImpl)) {
                    impl = new LogSvrImpl();
                }
                LogSvr.setInstance((com.bokesoft.yes.common.log.ILogSvr)impl);
            }
            LogSvr.getInstance().info(StringTable.getString(null, "", "SysInit"));
            String dsn = coreSetting.getDSN();
            if (dsn == null || dsn.isEmpty()) {
                this.startWithDSN = false;
            }
            String clazz = serverSetting.getDSNFactory();
            DefaultDSNFactory dsnFactory = null;
            dsnFactory = clazz != null && !clazz.isEmpty() ? (IDSNFactory)ReflectUtil.newInstance((String)clazz) : new DefaultDSNFactory();
            dsnFactory.init();
            DSNFactory.setInstance((IDSNFactory)dsnFactory);
            MidEnvManager envManager = new MidEnvManager();
            envManager.init();
            MidGlobalEnv.setInstance((MidGlobalEnv)envManager.getEnv());
            IMetaFactory metaFactory = envManager.getEnv().getMetaFactory();
            MidGlobalEnvState.setRunningVersion((String)envManager.getEnv().getVersion());
            String solutionKey = metaFactory.getSolution().getKey();
            File fileDeploy = new File(SvrInfo.getWorkDir() + "deploy.xml");
            if (fileDeploy.exists()) {
                MetaDeployLoad deployLoad = new MetaDeployLoad(1);
                deployLoad.load((IMetaResolver)new FileResourceResolver(fileDeploy.getAbsolutePath()), "");
                serverSetting.setDeploy((MetaDeploy)deployLoad.getRootMetaObject());
            }
            LogSvr.getInstance().info(SimpleStringFormat.format((String)StringTable.getString(null, "", "ReadSolution"), (Object[])new Object[]{solutionKey}));
            MetaSetting setting = metaFactory.getSetting();
            if (setting != null && (IOService = setting.getIOService()) != null) {
                for (MetaIOProvider provider : IOService) {
                    Class<?> providerClass = Class.forName(provider.getDriver());
                    DocumentIOFactory documentIOFactory = (DocumentIOFactory)providerClass.newInstance();
                    IOFactory.setDocumentIOFactory((String)provider.getKey(), (DocumentIOFactory)documentIOFactory);
                }
            }
        }
        catch (MissingResourceException e) {
            LogSvr.getInstance().error("missing core", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("start yigo error", e);
            throw e;
        }
    }

    protected void initSessionCacheInfo(IMetaFactory metaFactory) {
        SimpleSessionInfoProvider simpleProvider = new SimpleSessionInfoProvider();
        MobileSessionInfoProvider mobileProvider = new MobileSessionInfoProvider();
        TempSessionInfoProvider tmpProvider = new TempSessionInfoProvider();
        OvertimeSessionInfoProvider overtimeProvider = new OvertimeSessionInfoProvider();
        MetaSetting setting = metaFactory.getSetting();
        MetaSimpleSetting mss = null;
        if (setting != null) {
            String clazz;
            try {
                mss = setting.getSimpleSetting("SimpleSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    simpleProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LogSvr.getInstance().error("SimpleSessionInfoProvider is error.", e);
            }
            try {
                mss = setting.getSimpleSetting("MobileSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    mobileProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LogSvr.getInstance().error("MobileSessionInfoProvider is error.", e);
            }
            try {
                mss = setting.getSimpleSetting("TempSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    tmpProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LogSvr.getInstance().error("TempSessionInfoProvider is error.", e);
            }
            try {
                mss = setting.getSimpleSetting("OvertimeSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    overtimeProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LogSvr.getInstance().error("OvertimeSessionInfoProvider is error.", e);
            }
        }
        SessionInfoProviderHolder.setSimpleInstance((ISessionInfoProvider)simpleProvider);
        SessionInfoProviderHolder.setMobileInstance((ISessionInfoProvider)mobileProvider);
        SessionInfoProviderHolder.setTempInstance((ISessionInfoProvider)tmpProvider);
        SessionInfoProviderHolder.setOvertimeInstance((ISessionInfoProvider)overtimeProvider);
        simpleProvider = SessionInfoProviderHolder.getSimpleProvider();
        ISessionInfoMap simpleMap = simpleProvider.getSessionInfoMap();
        mobileProvider = SessionInfoProviderHolder.getMobileProvider();
        ISessionInfoMap mobileMap = mobileProvider.getSessionInfoMap();
        tmpProvider = SessionInfoProviderHolder.getTempProvider();
        ISessionInfoMap tmpMap = tmpProvider.getSessionInfoMap();
        if (setting != null) {
            MetaSession metaSession = setting.getSession();
            simpleMap.setTimeout(metaSession == null ? 3600 : metaSession.getTimeout());
            mobileMap.setTimeout(metaSession == null ? 3600 : metaSession.getDelMobileTimeout());
            tmpMap.setTimeout(metaSession == null ? 3600 : metaSession.getTimeout());
        } else {
            simpleMap.setTimeout(3600);
            mobileMap.setTimeout(3600);
            tmpMap.setTimeout(3600);
        }
    }

    protected void initAccountLockoutInfo(IMetaFactory metaFactory) {
        IAccountLockoutInfoMap lockInfo = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
        MetaSetting setting = metaFactory.getSetting();
        if (setting != null) {
            MetaSession metaSession = setting.getSession();
            lockInfo.setAccountLockoutDuration(metaSession == null ? 0 : metaSession.getAccountLockoutDuration());
            lockInfo.setAccountLockoutThreshold(metaSession == null ? 0 : metaSession.getAccountLockoutThreshold());
        }
    }

    protected void initCacheFactory(String cacheName, IMetaFactory metaFactory) {
        switch (cacheName) {
            case "redis": {
                CacheFactory.setInstance((ICacheFactory)new RedisCacheFactory());
                LogSvr.getInstance().info("use app cache " + cacheName);
                break;
            }
            case "ehcache": 
            case "simple": {
                if ("ehcache".equals(cacheName)) {
                    LogSvr.getInstance().info("ehcache deprecated, use simple instead");
                }
                CacheFactory.setInstance((ICacheFactory)new SimpleCacheFactory());
                LogSvr.getInstance().info("use app cache simple");
                break;
            }
            default: {
                throw new MidAppException(4, SimpleStringFormat.format((String)StringTable.getString(null, "", "UnknownCacheName"), (Object[])new Object[]{cacheName}));
            }
        }
    }

    protected void initSessionCacheFactory(String cacheName, IMetaFactory metaFactory) {
        switch (cacheName) {
            case "redis": {
                SessionCacheFactory.setInstance((com.bokesoft.yigo.mid.session.ICacheFactory)new RedisSessionCacheFactory(metaFactory));
                LogSvr.getInstance().info("use session cache " + cacheName.toLowerCase());
                break;
            }
            case "simple": 
            case "ehcache": {
                if ("ehcache".equals(cacheName)) {
                    LogSvr.getInstance().info("ehcache deprecated, use simple instead");
                }
                SessionCacheFactory.setInstance((com.bokesoft.yigo.mid.session.ICacheFactory)new SimpleSessionCacheFactory());
                LogSvr.getInstance().info("use session cache simple");
                break;
            }
            default: {
                throw new MidAppException(4, SimpleStringFormat.format((String)StringTable.getString(null, "", "UnknownCacheName"), (Object[])new Object[]{cacheName}));
            }
        }
    }

    private void midProcessInit() {
        MidProcessFlowHandler.addProcessFactory((String)"DBNamedQuery", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.DBNamedQueryProcess");
        MidProcessFlowHandler.addProcessFactory((String)"DBNamedUpdate", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.DBNamedUpdateProcess");
        MidProcessFlowHandler.addProcessFactory((String)"InvokeExtServiceCmd", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.InvokeExtServiceProcess");
        MidProcessFlowHandler.addProcessFactory((String)"InvokeExtService2Cmd", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.InvokeExtService2Process");
        MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.DeleteDataRightsProcess");
        MidProcessFlowHandler.addProcessFactory((String)"LoadData", (String)"Post", (String)"com.bokesoft.pub.mid.filter.process.LoadDataRightsProcess");
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.SaveDataRightsProcess");
        MidProcessFlowHandler.addProcessFactory((String)"LoadData", (String)"Post", (IServiceProcessFactory)new LoadBPMFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Pre", (IServiceProcessFactory)new DataMapLogicCheckFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Post", (IServiceProcessFactory)new SaveBPMDataMapFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Post", (IServiceProcessFactory)new BPMDataMigrationFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Post", (IServiceProcessFactory)new LoadBPMFactory());
        MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Pre", (IServiceProcessFactory)new DataMapLogicCheckFactory());
        MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Post", (IServiceProcessFactory)new KillInstancesFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void midQuartzStart(DefaultContext context) throws Throwable {
        if (!this.startWithDSN) {
            return;
        }
        LogSvr.getInstance().info("start quartz job");
        QuartzManager quartzManager = QuartzManager.getInstance();
        try (InputStream fis = PropertyUtil.readProperties((String)"quartz.properties");){
            quartzManager.init(fis);
            quartzManager.addJob("SessionJob", "SessionGroup", "SessionTriggerName", "SessionTriggerGroup", (Job)new EvictExpiredSessionJob(), "check overtime session", 1200000L, -1, 900000L);
            quartzManager.addJob("DictMaintain", "DictMaintain", "DictMaintain", "DictMaintain", (Job)new DictMaintainScheduleJob(), "DictMaintain", 600000L, -1, 600000L);
            MetaBPMSetting bpmSetting = context.getVE().getMetaFactory().getSetting().getBPMSetting();
            if (bpmSetting == null || bpmSetting.isUseDefaultRetreateDelegateTimer()) {
                quartzManager.addJob("EvictExpiredDelegate", "EvictExpiredDelegate", "EvictExpiredDelegate", "EvictExpiredDelegate", (Job)new EvictExpiredDelegateJob(), "EvictExpiredDelegate", 600000L, -1, 600000L);
            }
            if (bpmSetting == null || bpmSetting.isUseDefaultExecTimeoutItemTimer()) {
                quartzManager.addJob("ExecTimeoutItem", "ExecTimeoutItem", "ExecTimeoutItem", "ExecTimeoutItem", (Job)new ExecTimeoutItemJob(), "ExecTimeoutItem", 300000L, -1, 600000L);
            }
            quartzManager.start();
        }
    }

    public void doBackgroundTask(DefaultContext context) throws Throwable {
        BackgroundTask task = new BackgroundTask();
        task.handleTask(context);
    }

    protected void dealwithSolutions(PropertyResourceBundle coreBundle, CoreSetting coreSetting) throws Throwable {
    }
}

